/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.platform;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.lib.model.baked.EmptyVirtualBlockGetter;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.createmod.catnip.client.render.model.ShadeSeparatedBufferSource;
import net.createmod.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.createmod.catnip.impl.client.render.model.BakedModelBuffererImpl;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.platform.services.ModClientHooksHelper;
import net.createmod.catnip.render.ShadedBlockSbbBuilder;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.mixin.client.accessor.ParticleEngineAccessor;
import net.createmod.ponder.render.ForgeShadedBlockSbbBuilder;
import net.createmod.ponder.render.VirtualRenderHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class ForgeClientHooksHelper
implements ModClientHooksHelper {
    private final Map<ResourceLocation, ParticleProvider<?>> particleProviders;

    public ForgeClientHooksHelper() {
        this.particleProviders = ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).ponder$getProviders();
    }

    @Override
    public Locale getCurrentLocale() {
        return Minecraft.m_91087_().m_91102_().getJavaLocale();
    }

    @Override
    @Nullable
    public <T extends ParticleOptions> Particle createParticleFromData(T data, ClientLevel level, double x, double y, double z, double mx, double my, double mz) {
        ResourceLocation key = CatnipServices.REGISTRIES.getKeyOrThrow(data.m_6012_());
        ParticleProvider<?> particleProvider = this.particleProviders.get(key);
        return particleProvider == null ? null : particleProvider.m_6966_(data, level, x, y, z, mx, my, mz);
    }

    @Override
    public Minecraft getMinecraftFromScreen(Screen screen) {
        return screen.getMinecraft();
    }

    @Override
    public boolean isKeyPressed(KeyMapping mapping) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)mapping.getKey().m_84873_());
    }

    @Override
    public void enableStencilBuffer(RenderTarget renderTarget) {
        renderTarget.enableStencil();
    }

    @Override
    public void renderFullFluidState(PoseStack ms, MultiBufferSource.BufferSource buffer, FluidState fluid) {
        CatnipServices.FLUID_RENDERER.renderFluidBox(fluid, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, (MultiBufferSource)buffer, ms, 0xF000F0, false, true);
    }

    @Override
    public void bufferModel(BakedModel model, BlockPos pos, BlockAndTintGetter level, BlockState state, @Nullable PoseStack poseStack, ShadeSeparatedBufferSource bufferSource) {
        BakedModelBuffererImpl.bufferModel(model, pos, level, state, poseStack, null, bufferSource);
    }

    @Override
    public void bufferModel(BakedModel model, BlockPos pos, BlockAndTintGetter level, BlockState state, @Nullable PoseStack poseStack, ShadeSeparatedResultConsumer resultConsumer) {
        BakedModelBuffererImpl.bufferModel(model, pos, level, state, poseStack, null, resultConsumer);
    }

    @Override
    public void bufferBlocks(Iterator<BlockPos> posIterator, BlockAndTintGetter level, @Nullable PoseStack poseStack, boolean renderFluids, ShadeSeparatedBufferSource bufferSource) {
        BakedModelBuffererImpl.bufferBlocks(posIterator, level, poseStack, null, renderFluids, bufferSource);
    }

    @Override
    public void bufferBlocks(Iterator<BlockPos> posIterator, BlockAndTintGetter level, @Nullable PoseStack poseStack, boolean renderFluids, ShadeSeparatedResultConsumer resultConsumer) {
        BakedModelBuffererImpl.bufferBlocks(posIterator, level, poseStack, null, renderFluids, resultConsumer);
    }

    @Override
    public ShadedBlockSbbBuilder createSbbBuilder(BufferBuilder builder) {
        return new ForgeShadedBlockSbbBuilder(builder);
    }

    @Override
    public Iterable<RenderType> getRenderTypesForBlockModel(BlockState state, RandomSource random, @Nullable BlockEntity beWithModelData) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        ModelData modelData = beWithModelData != null ? beWithModelData.getModelData() : ModelData.EMPTY;
        return model.getRenderTypes(state, random, modelData);
    }

    @Override
    public boolean doesBlockModelContainRenderType(RenderType layer, BlockState state, RandomSource random, @Nullable BlockEntity beWithModelData) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        ModelData modelData = beWithModelData != null ? beWithModelData.getModelData() : ModelData.EMPTY;
        return model.getRenderTypes(state, random, modelData).contains(layer);
    }

    @Override
    public void tesselateBlockVirtual(BlockRenderDispatcher dispatcher, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, boolean checkSides, RandomSource randomSource, long seed, int packedOverlay, @Nullable RenderType renderType) {
        ModelBlockRenderer modelRenderer = dispatcher.m_110937_();
        ModelData modelData = model.getModelData((BlockAndTintGetter)EmptyVirtualBlockGetter.FULL_DARK, pos, state, VirtualRenderHelper.VIRTUAL_DATA);
        modelRenderer.tesselateBlock((BlockAndTintGetter)EmptyVirtualBlockGetter.FULL_DARK, model, state, pos, poseStack, consumer, checkSides, randomSource, seed, packedOverlay, modelData, renderType);
    }

    @Override
    public void tesselateBlockVirtual(Level level, BlockRenderDispatcher dispatcher, BakedModel model, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer consumer, boolean checkSides, RandomSource randomSource, long seed, int packedOverlay, @Nullable RenderType renderType) {
        ModelBlockRenderer modelRenderer = dispatcher.m_110937_();
        BlockEntity blockEntity = level.m_7702_(pos);
        ModelData modelData = model.getModelData((BlockAndTintGetter)level, pos, state, blockEntity == null ? ModelData.EMPTY : blockEntity.getModelData());
        modelRenderer.tesselateBlock((BlockAndTintGetter)level, model, state, pos, poseStack, consumer, checkSides, randomSource, seed, packedOverlay, modelData, renderType);
    }

    @Override
    public void renderGuiGameElementModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack ms, BlockState blockState, BakedModel blockModel, int color, @Nullable BlockEntity beWithModelData) {
        ModelData modelData;
        ModelData modelData2 = modelData = beWithModelData != null ? beWithModelData.getModelData() : VirtualRenderHelper.VIRTUAL_DATA;
        if (blockState.m_60734_() == Blocks.f_50016_) {
            RenderType renderType = Sheets.m_110792_();
            blockRenderer.m_110937_().renderModel(ms.m_85850_(), buffer.m_6299_(renderType), blockState, blockModel, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, modelData, null);
        } else {
            int blockColor = Minecraft.m_91087_().m_91298_().m_92577_(blockState, null, null, 0);
            Color rgb = new Color(blockColor == -1 ? color : blockColor);
            for (RenderType chunkType : blockModel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), VirtualRenderHelper.VIRTUAL_DATA)) {
                RenderType renderType = RenderTypeHelper.getEntityRenderType((RenderType)chunkType, (boolean)true);
                blockRenderer.m_110937_().renderModel(ms.m_85850_(), buffer.m_6299_(renderType), blockState, blockModel, rgb.getRedAsFloat(), rgb.getGreenAsFloat(), rgb.getBlueAsFloat(), 0xF000F0, OverlayTexture.f_118083_, modelData, chunkType);
            }
        }
    }

    @Override
    public void renderVirtualBlockStateModel(BlockRenderDispatcher dispatcher, PoseStack ms, VertexConsumer consumer, BlockState state, BakedModel model, float red, float green, float blue, RenderType layer) {
        dispatcher.m_110937_().renderModel(ms.m_85850_(), consumer, state, model, red, green, blue, 0xF000F0, OverlayTexture.f_118083_, VirtualRenderHelper.VIRTUAL_DATA, layer);
    }

    @Override
    public void vertexConsumerPutBulkDataWithAlpha(VertexConsumer consumer, PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        consumer.putBulkData(pose, quad, red, green, blue, alpha, packedLight, packedOverlay, true);
    }
}

