/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.levelWrappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.createmod.catnip.levelWrappers.SchematicChunkSource;
import net.createmod.catnip.levelWrappers.SchematicLevelAccessor;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.createmod.catnip.math.BBHelper;
import net.createmod.catnip.nbt.NBTProcessors;
import net.createmod.ponder.Ponder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;

public class SchematicLevel
extends WrappedLevel
implements ServerLevelAccessor,
SchematicLevelAccessor {
    protected Map<BlockPos, BlockState> blocks;
    protected Map<BlockPos, BlockEntity> blockEntities;
    protected List<BlockEntity> renderedBlockEntities;
    protected List<Entity> entities;
    protected BoundingBox bounds;
    public BlockPos anchor;
    public boolean renderMode;

    public SchematicLevel(Level original) {
        this(BlockPos.f_121853_, original);
    }

    public SchematicLevel(BlockPos anchor, Level original) {
        super(original);
        this.setChunkSource(new SchematicChunkSource(this));
        this.blocks = new HashMap<BlockPos, BlockState>();
        this.blockEntities = new HashMap<BlockPos, BlockEntity>();
        this.bounds = new BoundingBox(BlockPos.f_121853_);
        this.anchor = anchor;
        this.entities = new ArrayList<Entity>();
        this.renderedBlockEntities = new ArrayList<BlockEntity>();
    }

    @Override
    public Set<BlockPos> getAllPositions() {
        return this.blocks.keySet();
    }

    @Override
    public boolean m_7967_(Entity entityIn) {
        if (entityIn instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entityIn;
            itemFrame.m_31805_(NBTProcessors.withUnsafeNBTDiscarded(itemFrame.m_31822_()));
        }
        if (entityIn instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entityIn;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                armorStand.m_8061_(equipmentSlot, NBTProcessors.withUnsafeNBTDiscarded(armorStand.m_6844_(equipmentSlot)));
            }
        }
        return this.entities.add(entityIn);
    }

    @Override
    public List<Entity> getEntityList() {
        return this.entities;
    }

    @Override
    public BlockEntity m_7702_(BlockPos pos) {
        if (this.m_151570_(pos)) {
            return null;
        }
        if (this.blockEntities.containsKey(pos)) {
            return this.blockEntities.get(pos);
        }
        if (!this.blocks.containsKey(pos.m_121996_((Vec3i)this.anchor))) {
            return null;
        }
        BlockState blockState = this.m_8055_(pos);
        if (blockState.m_155947_()) {
            try {
                BlockEntity blockEntity = ((EntityBlock)blockState.m_60734_()).m_142194_(pos, blockState);
                if (blockEntity != null) {
                    this.onBEadded(blockEntity, pos);
                    this.blockEntities.put(pos, blockEntity);
                    this.renderedBlockEntities.add(blockEntity);
                }
                return blockEntity;
            }
            catch (Exception e) {
                Ponder.LOGGER.debug("Could not create BlockEntity of block " + String.valueOf(blockState), (Throwable)e);
            }
        }
        return null;
    }

    protected void onBEadded(BlockEntity blockEntity, BlockPos pos) {
        blockEntity.m_142339_((Level)this);
    }

    @Override
    public BlockState m_8055_(BlockPos globalPos) {
        BlockPos pos = globalPos.m_121996_((Vec3i)this.anchor);
        if (pos.m_123342_() - this.bounds.m_162396_() == -1 && !this.renderMode) {
            return Blocks.f_50493_.m_49966_();
        }
        if (this.getBounds().m_71051_((Vec3i)pos) && this.blocks.containsKey(pos)) {
            return this.processBlockStateForPrinting(this.blocks.get(pos));
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public Map<BlockPos, BlockState> getBlockMap() {
        return this.blocks;
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public Holder<Biome> m_204166_(BlockPos pos) {
        return this.level.m_9598_().m_255025_(Registries.f_256952_).m_255043_(Biomes.f_48202_);
    }

    public int m_45517_(LightLayer lightLayer, BlockPos pos) {
        return 15;
    }

    @Override
    public float m_7717_(Direction face, boolean hasShade) {
        return 1.0f;
    }

    @Override
    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    @Override
    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public List<Entity> m_6249_(Entity arg0, AABB arg1, Predicate<? super Entity> arg2) {
        return Collections.emptyList();
    }

    public <T extends Entity> List<T> m_6443_(Class<T> arg0, AABB arg1, Predicate<? super T> arg2) {
        return Collections.emptyList();
    }

    @Override
    public List<? extends Player> m_6907_() {
        return Collections.emptyList();
    }

    public int m_7445_() {
        return 0;
    }

    @Override
    public boolean m_7433_(BlockPos pos, Predicate<BlockState> predicate) {
        return predicate.test(this.m_8055_(pos));
    }

    public boolean m_46961_(BlockPos arg0, boolean arg1) {
        return this.m_7731_(arg0, Blocks.f_50016_.m_49966_(), 3);
    }

    public boolean m_7471_(BlockPos arg0, boolean arg1) {
        return this.m_7731_(arg0, Blocks.f_50016_.m_49966_(), 3);
    }

    @Override
    public boolean m_7731_(BlockPos pos, BlockState arg1, int arg2) {
        BlockEntity blockEntity;
        pos = pos.m_7949_().m_121996_((Vec3i)this.anchor);
        this.bounds = BBHelper.encapsulate(this.bounds, pos);
        this.blocks.put(pos, arg1);
        if (this.blockEntities.containsKey(pos) && !(blockEntity = this.blockEntities.get(pos)).m_58903_().m_155262_(arg1)) {
            this.blockEntities.remove(pos);
            this.renderedBlockEntities.remove(blockEntity);
        }
        if ((blockEntity = this.m_7702_(pos)) != null) {
            this.blockEntities.put(pos, blockEntity);
        }
        return true;
    }

    @Override
    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    @Override
    public BoundingBox getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(BoundingBox bounds) {
        this.bounds = bounds;
    }

    @Override
    public Iterable<BlockEntity> getBlockEntities() {
        return this.blockEntities.values();
    }

    @Override
    public Iterable<BlockEntity> getRenderedBlockEntities() {
        return this.renderedBlockEntities;
    }

    protected BlockState processBlockStateForPrinting(BlockState state) {
        if (state.m_60734_() instanceof AbstractFurnaceBlock && state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public ServerLevel m_6018_() {
        if (this.level instanceof ServerLevel) {
            return (ServerLevel)this.level;
        }
        throw new IllegalStateException("Cannot use IServerWorld#getWorld in a client environment");
    }
}

