/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.impl.client.render.model;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.createmod.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.UnknownNullability;

class MeshEmitter {
    private final RenderType renderType;
    private final BufferBuilder bufferBuilder;
    private @UnknownNullability ShadeSeparatedResultConsumer resultConsumer;
    private boolean currentShade;

    MeshEmitter(RenderType renderType) {
        this.renderType = renderType;
        this.bufferBuilder = new BufferBuilder(renderType.m_110507_());
    }

    public void prepare(ShadeSeparatedResultConsumer resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public void end() {
        if (this.bufferBuilder.m_85732_()) {
            this.emit();
        }
        this.resultConsumer = null;
    }

    public BufferBuilder getBuffer(boolean shade) {
        this.prepareForGeometry(shade);
        return this.bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (!this.bufferBuilder.m_85732_()) {
            this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        } else if (shade != this.currentShade) {
            this.emit();
            this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        }
        this.currentShade = shade;
    }

    private void emit() {
        BufferBuilder.RenderedBuffer renderedBuffer = this.bufferBuilder.m_231168_();
        if (renderedBuffer != null) {
            this.resultConsumer.accept(this.renderType, this.currentShade, renderedBuffer);
            renderedBuffer.m_231200_();
        }
    }
}

