/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.impl.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.lib.model.baked.VirtualBlockGetter;
import java.util.Iterator;
import java.util.function.Function;
import net.createmod.catnip.client.render.model.ShadeSeparatedBufferSource;
import net.createmod.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.createmod.catnip.impl.client.render.TransformingVertexConsumer;
import net.createmod.catnip.impl.client.render.model.DefaultShadeSeparatedBufferSource;
import net.createmod.catnip.impl.client.render.model.UniversalMeshEmitter;
import net.createmod.ponder.render.VirtualRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public final class BakedModelBuffererImpl {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private BakedModelBuffererImpl() {
    }

    public static void bufferModel(BakedModel model, BlockPos pos, BlockAndTintGetter level, BlockState state, @Nullable PoseStack poseStack, @Nullable ModelData modelData, ShadeSeparatedBufferSource bufferSource) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        if (modelData == null) {
            BlockEntity blockEntity = level.m_7702_(pos);
            modelData = blockEntity != null ? blockEntity.getModelData() : (level instanceof VirtualBlockGetter ? VirtualRenderHelper.VIRTUAL_DATA : ModelData.EMPTY);
        }
        RandomSource random = objects.random;
        UniversalMeshEmitter universalEmitter = objects.universalEmitter;
        long seed = state.m_60726_(pos);
        modelData = model.getModelData(level, pos, state, modelData);
        random.m_188584_(seed);
        ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, random, modelData);
        ModelBlockRenderer blockRenderer = Minecraft.m_91087_().m_91289_().m_110937_();
        for (RenderType renderType : renderTypes) {
            universalEmitter.prepare(bufferSource, renderType);
            poseStack.m_85836_();
            blockRenderer.tesselateBlock(level, model, state, pos, poseStack, (VertexConsumer)universalEmitter, false, random, seed, OverlayTexture.f_118083_, modelData, renderType);
            poseStack.m_85849_();
        }
        universalEmitter.clear();
    }

    public static void bufferModel(BakedModel model, BlockPos pos, BlockAndTintGetter level, BlockState state, @Nullable PoseStack poseStack, @Nullable ModelData modelData, ShadeSeparatedResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        DefaultShadeSeparatedBufferSource bufferSource = objects.defaultBufferSource;
        bufferSource.prepare(resultConsumer);
        BakedModelBuffererImpl.bufferModel(model, pos, level, state, poseStack, modelData, bufferSource);
        bufferSource.end();
    }

    public static void bufferBlocks(Iterator<BlockPos> posIterator, BlockAndTintGetter level, @Nullable PoseStack poseStack, @Nullable Function<BlockPos, ModelData> modelDataLookup, boolean renderFluids, ShadeSeparatedBufferSource bufferSource) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        if (poseStack == null) {
            poseStack = objects.identityPoseStack;
        }
        if (modelDataLookup == null) {
            modelDataLookup = pos -> {
                BlockEntity blockEntity = level.m_7702_(pos);
                return blockEntity != null ? blockEntity.getModelData() : (level instanceof VirtualBlockGetter ? VirtualRenderHelper.VIRTUAL_DATA : ModelData.EMPTY);
            };
        }
        RandomSource random = objects.random;
        UniversalMeshEmitter universalEmitter = objects.universalEmitter;
        TransformingVertexConsumer transformingWrapper = objects.transformingWrapper;
        BlockRenderDispatcher renderDispatcher = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer blockRenderer = renderDispatcher.m_110937_();
        ModelBlockRenderer.m_111000_();
        while (posIterator.hasNext()) {
            FluidState fluidState;
            BlockPos pos2 = posIterator.next();
            BlockState state = level.m_8055_(pos2);
            if (renderFluids && !(fluidState = state.m_60819_()).m_76178_()) {
                RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
                transformingWrapper.prepare(bufferSource.getBuffer(renderType, true), poseStack);
                poseStack.m_85836_();
                poseStack.m_252880_((float)(pos2.m_123341_() - (pos2.m_123341_() & 0xF)), (float)(pos2.m_123342_() - (pos2.m_123342_() & 0xF)), (float)(pos2.m_123343_() - (pos2.m_123343_() & 0xF)));
                renderDispatcher.m_234363_(pos2, level, (VertexConsumer)transformingWrapper, state, fluidState);
                poseStack.m_85849_();
            }
            if (state.m_60799_() != RenderShape.MODEL) continue;
            long seed = state.m_60726_(pos2);
            BakedModel model = renderDispatcher.m_110910_(state);
            ModelData modelData = modelDataLookup.apply(pos2);
            modelData = model.getModelData(level, pos2, state, modelData);
            random.m_188584_(seed);
            ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, random, modelData);
            for (RenderType renderType : renderTypes) {
                universalEmitter.prepare(bufferSource, renderType);
                poseStack.m_85836_();
                poseStack.m_252880_((float)pos2.m_123341_(), (float)pos2.m_123342_(), (float)pos2.m_123343_());
                blockRenderer.tesselateBlock(level, model, state, pos2, poseStack, (VertexConsumer)universalEmitter, true, random, seed, OverlayTexture.f_118083_, modelData, renderType);
                poseStack.m_85849_();
            }
        }
        ModelBlockRenderer.m_111077_();
        transformingWrapper.clear();
        universalEmitter.clear();
    }

    public static void bufferBlocks(Iterator<BlockPos> posIterator, BlockAndTintGetter level, @Nullable PoseStack poseStack, @Nullable Function<BlockPos, ModelData> modelDataLookup, boolean renderFluids, ShadeSeparatedResultConsumer resultConsumer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        DefaultShadeSeparatedBufferSource bufferSource = objects.defaultBufferSource;
        bufferSource.prepare(resultConsumer);
        BakedModelBuffererImpl.bufferBlocks(posIterator, level, poseStack, modelDataLookup, renderFluids, bufferSource);
        bufferSource.end();
    }

    private static class ThreadLocalObjects {
        public final PoseStack identityPoseStack = new PoseStack();
        public final RandomSource random = RandomSource.m_216343_();
        public final DefaultShadeSeparatedBufferSource defaultBufferSource = new DefaultShadeSeparatedBufferSource();
        public final UniversalMeshEmitter universalEmitter = new UniversalMeshEmitter();
        public final TransformingVertexConsumer transformingWrapper = new TransformingVertexConsumer();

        private ThreadLocalObjects() {
        }
    }
}

