/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.ghostblock;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.engine_room.flywheel.lib.model.baked.EmptyVirtualBlockGetter;
import net.createmod.catnip.client.render.model.BakedModelBufferer;
import net.createmod.catnip.ghostblock.GhostBlockParams;
import net.createmod.catnip.impl.client.render.ColoringVertexConsumer;
import net.createmod.catnip.placement.PlacementClient;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();
    private static final GhostBlockRenderer TRANSPARENT = new TransparentGhostBlockRenderer();

    public static GhostBlockRenderer standard() {
        return STANDARD;
    }

    public static GhostBlockRenderer transparent() {
        return TRANSPARENT;
    }

    public abstract void render(PoseStack var1, SuperRenderTypeBuffer var2, Vec3 var3, GhostBlockParams var4);

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, GhostBlockParams params) {
            BlockState state = params.state;
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
            BlockPos pos = params.pos;
            ms.m_85836_();
            ms.m_85837_((double)pos.m_123341_() - camera.f_82479_, (double)pos.m_123342_() - camera.f_82480_, (double)pos.m_123343_() - camera.f_82481_);
            BakedModelBufferer.bufferModel(model, pos, (BlockAndTintGetter)EmptyVirtualBlockGetter.FULL_BRIGHT, state, ms, (layer, shade) -> buffer.getEarlyBuffer(layer));
            ms.m_85849_();
        }
    }

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, GhostBlockParams params) {
            BlockState state = params.state;
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
            BlockPos pos = params.pos;
            float alpha = params.alphaSupplier.get().floatValue() * 0.75f * PlacementClient.getCurrentAlpha();
            ColoringVertexConsumer vb = new ColoringVertexConsumer(buffer.getEarlyBuffer(RenderType.m_110466_()), 1.0f, 1.0f, 1.0f, alpha);
            ms.m_85836_();
            ms.m_85837_((double)pos.m_123341_() - camera.f_82479_, (double)pos.m_123342_() - camera.f_82480_, (double)pos.m_123343_() - camera.f_82481_);
            ms.m_85837_(0.5, 0.5, 0.5);
            ms.m_85841_(0.85f, 0.85f, 0.85f);
            ms.m_85837_(-0.5, -0.5, -0.5);
            BakedModelBufferer.bufferModel(model, pos, (BlockAndTintGetter)EmptyVirtualBlockGetter.FULL_BRIGHT, state, ms, (layer, shade) -> vb);
            ms.m_85849_();
        }
    }
}

