/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui.entries;

import com.mojang.blaze3d.platform.ClipboardManager;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.createmod.catnip.config.ui.ConfigAnnotations;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.ConfigScreenList;
import net.createmod.catnip.config.ui.SubMenuConfigScreen;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ValueEntry<T>
extends ConfigScreenList.LabeledEntry {
    protected static final int resetWidth = 28;
    public static final ClipboardManager clipboardHelper = new ClipboardManager();
    protected ForgeConfigSpec.ConfigValue<T> value;
    protected ForgeConfigSpec.ValueSpec spec;
    protected BoxWidget resetButton;
    protected boolean editable = true;

    public ValueEntry(String label, ForgeConfigSpec.ConfigValue<T> value, ForgeConfigSpec.ValueSpec spec) {
        super(label);
        this.value = value;
        this.spec = spec;
        this.path = String.join((CharSequence)".", value.getPath());
        this.resetButton = (BoxWidget)((AbstractSimiWidget)new BoxWidget(0, 0, 16, 16).showingElement(PonderGuiTextures.ICON_CONFIG_RESET.asStencil())).withCallback(() -> {
            this.setValue(spec.getDefault());
            this.onReset();
        });
        this.resetButton.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.resetButton)));
        this.listeners.add(this.resetButton);
        List path = value.getPath();
        this.labelTooltip.add(Component.m_237113_((String)label).m_130940_(ChatFormatting.WHITE));
        String comment = spec.getComment();
        if (comment == null || comment.isEmpty()) {
            return;
        }
        ArrayList<String> commentLines = new ArrayList<String>(Arrays.asList(comment.split("\n")));
        Pair<String, Map<String, String>> metadata = ConfigHelper.readMetadataFromComment(commentLines);
        if (metadata.getFirst() != null) {
            this.unit = metadata.getFirst();
        }
        if (metadata.getSecond() != null && !metadata.getSecond().isEmpty()) {
            this.annotations.putAll(metadata.getSecond());
        }
        this.labelTooltip.addAll(commentLines.stream().filter(s -> !s.startsWith("Range")).map(s -> s.equals(".") ? " " : s).map(str -> Component.m_237113_((String)str)).flatMap(stc -> FontHelper.cutTextComponent((Component)stc, FontHelper.Palette.ALL_GRAY).stream()).toList());
        if (this.annotations.containsKey(ConfigAnnotations.RequiresRelog.TRUE.getName())) {
            this.labelTooltip.addAll(FontHelper.cutTextComponent((Component)Component.m_237113_((String)"Changing this value will require a _relog_ to take full effect"), FontHelper.Palette.GRAY_AND_GOLD));
        }
        if (this.annotations.containsKey(ConfigAnnotations.RequiresRestart.CLIENT.getName())) {
            this.labelTooltip.addAll(FontHelper.cutTextComponent((Component)Component.m_237113_((String)"Changing this value will require a _restart_ to take full effect"), FontHelper.Palette.GRAY_AND_RED));
        }
        this.labelTooltip.add(Component.m_237113_((String)(ConfigScreen.modID + ":" + (String)path.get(path.size() - 1))).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @Override
    protected void setEditable(boolean b) {
        this.editable = b;
        this.resetButton.f_93623_ = this.editable && !this.isCurrentValueDefault();
        this.resetButton.animateGradientFromState();
    }

    @Override
    public void tick() {
        super.tick();
        this.resetButton.tick();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        long handle = Minecraft.m_91087_().m_91268_().m_85439_();
        if (!InputConstants.m_84830_((long)handle, (int)341)) {
            return false;
        }
        ModConfig.Type configType = ModConfig.Type.CLIENT;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof SubMenuConfigScreen) {
            SubMenuConfigScreen subMenuScreen = (SubMenuConfigScreen)screen;
            configType = subMenuScreen.type;
        }
        this.annotations.put("highlight", ":)");
        clipboardHelper.m_83988_(handle, ConfigScreen.modID + ":" + configType.extension() + "." + this.path);
        return true;
    }

    @Override
    public void m_6311_(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.m_6311_(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        this.resetButton.m_252865_(x + width - 28 + 6);
        this.resetButton.m_252865_(y + 10);
        this.resetButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getLabelWidth(int totalWidth) {
        return (int)((float)totalWidth * 0.4f) + 30;
    }

    public void setValue(@Nonnull T value) {
        ConfigHelper.setValue(this.path, this.value, value, this.annotations);
        this.onValueChange(value);
    }

    @Nonnull
    public T getValue() {
        return ConfigHelper.getValue(this.path, this.value);
    }

    protected boolean isCurrentValueDefault() {
        return this.spec.getDefault().equals(this.getValue());
    }

    public void onReset() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange(T newValue) {
        this.resetButton.f_93623_ = this.editable && !this.isCurrentValueDefault();
        this.resetButton.animateGradientFromState();
    }

    protected void bumpCog() {
        this.bumpCog(10.0f);
    }

    protected void bumpCog(float force) {
        ConfigScreen.cogSpin.bump(3, force);
    }
}

