/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui.entries;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.ConfigTextField;
import net.createmod.catnip.config.ui.HintableTextFieldWidget;
import net.createmod.catnip.config.ui.entries.ValueEntry;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.TextStencilElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class NumberEntry<T extends Number>
extends ValueEntry<T> {
    @Nullable
    protected TextStencilElement minText = null;
    @Nullable
    protected TextStencilElement maxText = null;
    protected int minOffset = 0;
    protected int maxOffset = 0;
    protected HintableTextFieldWidget textField;

    @Nullable
    public static NumberEntry<? extends Number> create(Object type, String label, ForgeConfigSpec.ConfigValue<?> value, ForgeConfigSpec.ValueSpec spec) {
        if (type instanceof Integer) {
            return new IntegerEntry(label, (ForgeConfigSpec.ConfigValue<Integer>)value, spec);
        }
        if (type instanceof Float) {
            return new FloatEntry(label, (ForgeConfigSpec.ConfigValue<Float>)value, spec);
        }
        if (type instanceof Double) {
            return new DoubleEntry(label, (ForgeConfigSpec.ConfigValue<Double>)value, spec);
        }
        return null;
    }

    public NumberEntry(String label, ForgeConfigSpec.ConfigValue<T> value, ForgeConfigSpec.ValueSpec spec) {
        super(label, value, spec);
        this.textField = new ConfigTextField(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20);
        if (this instanceof IntegerEntry && this.annotations.containsKey("IntDisplay")) {
            String intDisplay = (String)this.annotations.get("IntDisplay");
            int intValue = (Integer)this.getValue();
            Object textValue = switch (intDisplay) {
                case "#" -> "#" + Integer.toHexString(intValue).toUpperCase(Locale.ROOT);
                case "0x" -> "0x" + Integer.toHexString(intValue).toUpperCase(Locale.ROOT);
                case "0b" -> "0b" + Integer.toBinaryString(intValue);
                default -> String.valueOf(intValue);
            };
            this.textField.m_94144_((String)textValue);
        } else {
            this.textField.m_94144_(String.valueOf(this.getValue()));
        }
        this.textField.m_94202_(((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        ForgeConfigSpec.Range range = spec.getRange();
        try {
            MutableComponent t;
            Field minField = range.getClass().getDeclaredField("min");
            Field maxField = range.getClass().getDeclaredField("max");
            minField.setAccessible(true);
            maxField.setAccessible(true);
            Number min = (Number)minField.get(range);
            Number max = (Number)maxField.get(range);
            Font font = Minecraft.m_91087_().f_91062_;
            if (min.doubleValue() > ((Number)this.getTypeMin()).doubleValue()) {
                t = Component.m_237113_((String)(this.formatBound(min) + " < "));
                this.minText = new TextStencilElement(font, t).centered(true, false);
                this.minText.withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, UIRenderHelper.COLOR_TEXT_DARKER));
                this.minOffset = font.m_92852_((FormattedText)t);
            }
            if (max.doubleValue() < ((Number)this.getTypeMax()).doubleValue()) {
                t = Component.m_237113_((String)(" < " + this.formatBound(max)));
                this.maxText = new TextStencilElement(font, t).centered(true, false);
                this.maxText.withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, UIRenderHelper.COLOR_TEXT_DARKER));
                this.maxOffset = font.m_92852_((FormattedText)t);
            }
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException | NullPointerException exception) {
            // empty catch block
        }
        this.textField.m_94151_(s -> {
            try {
                Number number = (Number)this.getParser().apply((String)s);
                if (!spec.test((Object)number)) {
                    throw new IllegalArgumentException();
                }
                this.textField.m_94202_(((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
                this.setValue(number);
            }
            catch (IllegalArgumentException ignored) {
                this.textField.m_94202_(((Color)AbstractSimiWidget.COLOR_FAIL.getFirst()).getRGB());
            }
        });
        this.textField.m_94198_();
        this.listeners.add(this.textField);
        this.onReset();
    }

    protected String formatBound(T bound) {
        String sci = String.format("%.2E", ((Number)bound).doubleValue());
        String str = String.valueOf(bound);
        return sci.length() < str.length() ? sci : str;
    }

    protected abstract T getTypeMin();

    protected abstract T getTypeMax();

    protected abstract Function<String, T> getParser();

    @Override
    protected void setEditable(boolean b) {
        super.setEditable(b);
        this.textField.m_94186_(b);
    }

    @Override
    public void onValueChange(T newValue) {
        super.onValueChange(newValue);
        try {
            Number current = (Number)this.getParser().apply(this.textField.m_94155_());
            if (!current.equals(newValue)) {
                this.textField.m_94144_(String.valueOf(newValue));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.textField.m_94120_();
    }

    @Override
    public void m_6311_(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.m_6311_(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        this.textField.m_252865_(x + width - 82 - 28);
        this.textField.m_253211_(y + 8);
        this.textField.m_93674_(Math.min(width - this.getLabelWidth(width) - 28 - this.minOffset - this.maxOffset, 40));
        this.textField.setHeight(20);
        this.textField.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.minText != null) {
            this.minText.at(this.textField.m_252754_() - this.minOffset, this.textField.m_252907_(), 0.0f).withBounds(this.minOffset, this.textField.m_93694_()).render(graphics);
        }
        if (this.maxText != null) {
            this.maxText.at(this.textField.m_252754_() + this.textField.m_5711_(), this.textField.m_252907_(), 0.0f).withBounds(this.maxOffset, this.textField.m_93694_()).render(graphics);
        }
    }

    public static class IntegerEntry
    extends NumberEntry<Integer> {
        public IntegerEntry(String label, ForgeConfigSpec.ConfigValue<Integer> value, ForgeConfigSpec.ValueSpec spec) {
            super(label, value, spec);
        }

        @Override
        protected Integer getTypeMin() {
            return Integer.MIN_VALUE;
        }

        @Override
        protected Integer getTypeMax() {
            return Integer.MAX_VALUE;
        }

        @Override
        protected Function<String, Integer> getParser() {
            return string -> {
                if (string.startsWith("#")) {
                    return Integer.parseUnsignedInt(string.substring(1), 16);
                }
                if (string.startsWith("0x")) {
                    return Integer.parseUnsignedInt(string.substring(2), 16);
                }
                if (string.startsWith("0b")) {
                    return Integer.parseUnsignedInt(string.substring(2), 2);
                }
                return Integer.parseInt(string);
            };
        }
    }

    public static class FloatEntry
    extends NumberEntry<Float> {
        public FloatEntry(String label, ForgeConfigSpec.ConfigValue<Float> value, ForgeConfigSpec.ValueSpec spec) {
            super(label, value, spec);
        }

        @Override
        protected Float getTypeMin() {
            return Float.valueOf(-3.4028235E38f);
        }

        @Override
        protected Float getTypeMax() {
            return Float.valueOf(Float.MAX_VALUE);
        }

        @Override
        protected Function<String, Float> getParser() {
            return Float::parseFloat;
        }
    }

    public static class DoubleEntry
    extends NumberEntry<Double> {
        public DoubleEntry(String label, ForgeConfigSpec.ConfigValue<Double> value, ForgeConfigSpec.ValueSpec spec) {
            super(label, value, spec);
        }

        @Override
        protected Double getTypeMin() {
            return -3.4028234663852886E38;
        }

        @Override
        protected Double getTypeMax() {
            return 3.4028234663852886E38;
        }

        @Override
        protected Function<String, Double> getParser() {
            return Double::parseDouble;
        }
    }
}

