/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui.entries;

import java.util.Locale;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.entries.ValueEntry;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.TextStencilElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.common.ForgeConfigSpec;

public class EnumEntry
extends ValueEntry<Enum<?>> {
    protected static final int cycleWidth = 34;
    protected TextStencilElement valueText;
    protected BoxWidget cycleLeft;
    protected BoxWidget cycleRight;

    public EnumEntry(String label, ForgeConfigSpec.ConfigValue<Enum<?>> value, ForgeConfigSpec.ValueSpec spec) {
        super(label, value, spec);
        this.valueText = new TextStencilElement(Minecraft.m_91087_().f_91062_, "YEP").centered(true, true);
        this.valueText.withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, UIRenderHelper.COLOR_TEXT));
        DelegatedStencilElement l = PonderGuiTextures.ICON_CONFIG_PREV.asStencil();
        this.cycleLeft = (BoxWidget)((AbstractSimiWidget)((ElementWidget)new BoxWidget(0, 0, 42, 16).withCustomBackground(BoxElement.COLOR_BACKGROUND_FLAT)).showingElement(l)).withCallback(() -> this.cycleValue(-1));
        l.withElementRenderer(BoxWidget.gradientFactory.apply(this.cycleLeft));
        DelegatedStencilElement r = PonderGuiTextures.ICON_CONFIG_NEXT.asStencil();
        this.cycleRight = (BoxWidget)((AbstractSimiWidget)((ElementWidget)new BoxWidget(0, 0, 42, 16).withCustomBackground(BoxElement.COLOR_BACKGROUND_FLAT)).showingElement(r)).withCallback(() -> this.cycleValue(1));
        r.at(26.0f, 0.0f);
        r.withElementRenderer(BoxWidget.gradientFactory.apply(this.cycleRight));
        this.listeners.add(this.cycleLeft);
        this.listeners.add(this.cycleRight);
        this.onReset();
    }

    protected void cycleValue(int direction) {
        Enum e = (Enum)this.getValue();
        Enum[] options = (Enum[])e.getDeclaringClass().getEnumConstants();
        e = options[Math.floorMod(e.ordinal() + direction, options.length)];
        this.setValue(e);
        this.bumpCog((float)direction * 15.0f);
    }

    @Override
    protected void setEditable(boolean b) {
        super.setEditable(b);
        this.cycleLeft.f_93623_ = b;
        this.cycleLeft.animateGradientFromState();
        this.cycleRight.f_93623_ = b;
        this.cycleRight.animateGradientFromState();
    }

    @Override
    public void tick() {
        super.tick();
        this.cycleLeft.tick();
        this.cycleRight.tick();
    }

    @Override
    public void m_6311_(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.m_6311_(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        this.cycleLeft.m_252865_(x + this.getLabelWidth(width) + 4);
        this.cycleLeft.m_253211_(y + 10);
        this.cycleLeft.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.valueText.at(this.cycleLeft.m_252754_() + 34 - 8, y + 10, 200.0f).withBounds(width - this.getLabelWidth(width) - 68 - 28 - 4, 16).render(graphics);
        this.cycleRight.m_252865_(x + width - 68 - 28 + 10);
        this.cycleRight.m_253211_(y + 10);
        this.cycleRight.m_88315_(graphics, mouseX, mouseY, partialTicks);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BoxElement.COLOR_BACKGROUND_FLAT)).flatBorder(0x1000000)).withBounds(48, 6).at(this.cycleLeft.m_252754_() + 22, this.cycleLeft.m_252907_() + 5).render(graphics);
    }

    @Override
    public void onValueChange(Enum<?> newValue) {
        super.onValueChange(newValue);
        this.valueText.withText(ConfigScreen.toHumanReadable(newValue.name().toLowerCase(Locale.ROOT)));
    }
}

