/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.Force;
import net.createmod.catnip.animation.PhysicalFloat;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.TriConsumer;

public abstract class ConfigScreen
extends AbstractSimiScreen {
    public static final Map<String, TriConsumer<Screen, GuiGraphics, Float>> backgrounds = new HashMap<String, TriConsumer<Screen, GuiGraphics, Float>>();
    public static final PhysicalFloat cogSpin = PhysicalFloat.create().withLimit(10.0f).withDrag(0.3).addForce(new Force.Static(0.2f));
    @Nullable
    public static String modID = null;
    @Nullable
    protected final Screen parent;
    public static BlockState shadowState = Blocks.f_50727_.m_49966_();
    public static DelegatedStencilElement shadowElement = new DelegatedStencilElement((graphics, x, y, alpha) -> ConfigScreen.renderCog(graphics), (graphics, x, y, alpha) -> graphics.m_280509_(-200, -200, 200, 200, 0x60000000));
    private static final PanoramaRenderer vanillaPanorama = new PanoramaRenderer(TitleScreen.f_96716_);

    public ConfigScreen(@Nullable Screen parent) {
        this.parent = parent;
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        cogSpin.tick();
    }

    public void m_280273_(GuiGraphics graphics) {
    }

    @Override
    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1339544524);
        } else {
            this.renderMenuBackground(graphics, partialTicks);
        }
        shadowElement.at((float)this.f_96543_ * 0.5f, (float)this.f_96544_ * 0.5f, 0.0f).render(graphics);
        super.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor(this.f_96541_.m_91385_(), UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)Minecraft.f_91002_);
    }

    @Override
    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor(UIRenderHelper.framebuffer, this.f_96541_.m_91385_());
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        cogSpin.bump(3, -delta * 5.0);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    public static String toHumanReadable(String key) {
        String s = key.replaceAll("_", " ");
        s = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)s)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        s = StringUtils.normalizeSpace((String)s);
        return s;
    }

    protected void renderMenuBackground(GuiGraphics graphics, float partialTicks) {
        TriConsumer<Screen, GuiGraphics, Float> customBackground = backgrounds.get(modID);
        if (customBackground != null) {
            customBackground.accept((Object)this, (Object)graphics, (Object)Float.valueOf(partialTicks));
            return;
        }
        vanillaPanorama.m_110003_(this.f_96541_.m_91297_(), 1.0f);
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1876415436);
    }

    protected static void renderCog(GuiGraphics graphics) {
        float partialTicks = Minecraft.m_91087_().m_91296_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(-100.0f, 100.0f, -100.0f);
        poseStack.m_85841_(200.0f, 200.0f, 1.0f);
        GuiGameElement.of(shadowState).rotateBlock(22.5, cogSpin.getValue(partialTicks), 22.5).render(graphics);
        poseStack.m_85849_();
    }
}

