/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class ConfigBase {
    @Nullable
    public ForgeConfigSpec specification;
    protected int depth;
    protected List<CValue<?, ?>> allValues = new ArrayList();
    protected List<ConfigBase> children = new ArrayList<ConfigBase>();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        for (CValue<?, ?> cValue : this.allValues) {
            cValue.register(builder);
        }
    }

    public void onLoad() {
        if (!this.children.isEmpty()) {
            this.children.forEach(ConfigBase::onLoad);
        }
    }

    public void onReload() {
        if (!this.children.isEmpty()) {
            this.children.forEach(ConfigBase::onReload);
        }
    }

    public abstract String getName();

    protected ConfigBool b(boolean current, String name, String ... comment) {
        return new ConfigBool(name, current, comment);
    }

    protected ConfigFloat f(float current, float min, float max, String name, String ... comment) {
        return new ConfigFloat(name, current, min, max, comment);
    }

    protected ConfigFloat f(float current, float min, String name, String ... comment) {
        return this.f(current, min, Float.MAX_VALUE, name, comment);
    }

    protected ConfigInt i(int current, int min, int max, String name, String ... comment) {
        return new ConfigInt(name, current, min, max, comment);
    }

    protected ConfigInt i(int current, int min, String name, String ... comment) {
        return this.i(current, min, Integer.MAX_VALUE, name, comment);
    }

    protected ConfigInt i(int current, String name, String ... comment) {
        return this.i(current, Integer.MIN_VALUE, Integer.MAX_VALUE, name, comment);
    }

    protected <T extends Enum<T>> ConfigEnum<T> e(T defaultValue, String name, String ... comment) {
        return new ConfigEnum(this, name, defaultValue, comment);
    }

    protected ConfigGroup group(int depth, String name, String ... comment) {
        return new ConfigGroup(name, depth, comment);
    }

    protected <T extends ConfigBase> T nested(int depth, Supplier<T> constructor, String ... comment) {
        ConfigBase config = (ConfigBase)constructor.get();
        new ConfigGroup(config.getName(), depth, comment);
        new CValue(config.getName(), builder -> {
            config.depth = depth;
            config.registerAll((ForgeConfigSpec.Builder)builder);
            if (config.depth > depth) {
                builder.pop(config.depth - depth);
            }
            return null;
        }, new String[0]);
        this.children.add(config);
        return (T)config;
    }

    public class CValue<V, T extends ForgeConfigSpec.ConfigValue<V>> {
        @Nullable
        protected ForgeConfigSpec.ConfigValue<V> value;
        protected String name;
        private final IValueProvider<V, T> provider;

        public CValue(String name, IValueProvider<V, T> provider, String ... comment) {
            this.name = name;
            this.provider = builder -> {
                this.addComments((ForgeConfigSpec.Builder)builder, comment);
                return (ForgeConfigSpec.ConfigValue)provider.apply(builder);
            };
            ConfigBase.this.allValues.add(this);
        }

        public void addComments(ForgeConfigSpec.Builder builder, String ... comment) {
            if (comment.length > 0) {
                String[] comments = new String[comment.length + 1];
                comments[0] = ".";
                System.arraycopy(comment, 0, comments, 1, comment.length);
                builder.comment(comments);
            } else {
                builder.comment(".");
            }
        }

        public void register(ForgeConfigSpec.Builder builder) {
            this.value = (ForgeConfigSpec.ConfigValue)this.provider.apply(builder);
        }

        public V get() {
            if (this.value == null) {
                throw new AssertionError((Object)("Config " + this.getName() + " was accessed, but not registered before!"));
            }
            return (V)this.value.get();
        }

        public void set(V value) {
            if (this.value == null) {
                throw new AssertionError((Object)("Config " + this.getName() + " was accessed, but not registered before!"));
            }
            this.value.set(value);
        }

        public String getName() {
            return this.name;
        }
    }

    public class ConfigBool
    extends CValue<Boolean, ForgeConfigSpec.BooleanValue> {
        public ConfigBool(String name, boolean def, String ... comment) {
            super(name, builder -> builder.define(name, def), comment);
        }
    }

    public class ConfigFloat
    extends CValue<Double, ForgeConfigSpec.DoubleValue> {
        public ConfigFloat(String name, float current, float min, float max, String ... comment) {
            super(name, builder -> builder.defineInRange(name, (double)current, (double)min, (double)max), comment);
        }

        public float getF() {
            return ((Double)this.get()).floatValue();
        }
    }

    public class ConfigInt
    extends CValue<Integer, ForgeConfigSpec.IntValue> {
        public ConfigInt(String name, int current, int min, int max, String ... comment) {
            super(name, builder -> builder.defineInRange(name, current, min, max), comment);
        }
    }

    public static class ConfigEnum<T extends Enum<T>>
    extends CValue<T, ForgeConfigSpec.EnumValue<T>> {
        final /* synthetic */ ConfigBase this$0;

        public ConfigEnum(String name, T defaultValue, String[] comment) {
            this.this$0 = this$0;
            super(name, builder -> builder.defineEnum(name, defaultValue), comment);
        }
    }

    public class ConfigGroup
    extends CValue<Boolean, ForgeConfigSpec.BooleanValue> {
        private final int groupDepth;
        private final String[] comment;

        public ConfigGroup(String name, int depth, String ... comment) {
            super(name, builder -> null, comment);
            this.groupDepth = depth;
            this.comment = comment;
        }

        @Override
        public void register(ForgeConfigSpec.Builder builder) {
            if (ConfigBase.this.depth > this.groupDepth) {
                builder.pop(ConfigBase.this.depth - this.groupDepth);
            }
            ConfigBase.this.depth = this.groupDepth;
            this.addComments(builder, this.comment);
            builder.push(this.getName());
            ++ConfigBase.this.depth;
        }
    }

    @FunctionalInterface
    protected static interface IValueProvider<V, T extends ForgeConfigSpec.ConfigValue<V>>
    extends Function<ForgeConfigSpec.Builder, T> {
    }
}

