/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.resource.LanguageUtils;
import nx.pingwheel.common.screen.SettingsScreen;
import org.apache.logging.log4j.util.TriConsumer;

public class ClientCommandBuilder {
    private ClientCommandBuilder() {
    }

    public static <S> LiteralArgumentBuilder<S> build(TriConsumer<CommandContext<S>, Boolean, MutableComponent> responseHandler) {
        LanguageUtils.LanguageWrapper langConfig = LanguageUtils.command("config");
        LanguageUtils.LanguageWrapper langChannel = LanguageUtils.command("channel");
        LiteralArgumentBuilder cmdChannel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"channel").executes(context -> {
            String currentChannel = ClientConfig.HANDLER.getConfig().getChannel();
            if (currentChannel.isEmpty()) {
                responseHandler.accept((Object)context, (Object)true, (Object)langChannel.path("get.response.default").get(new Object[0]));
            } else {
                responseHandler.accept((Object)context, (Object)true, (Object)langChannel.path("get.response").get(Component.m_237113_((String)currentChannel).m_130940_(ChatFormatting.YELLOW)));
            }
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"channel_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String newChannel = (String)context.getArgument("channel_name", String.class);
            if (newChannel.length() > 128) {
                responseHandler.accept((Object)context, (Object)false, (Object)langChannel.path("set.reject").get(128));
                return 0;
            }
            ClientConfig.HANDLER.getConfig().setChannel(newChannel);
            ClientConfig.HANDLER.save();
            if (newChannel.isEmpty()) {
                responseHandler.accept((Object)context, (Object)true, (Object)langChannel.path("set.response.default").get(new Object[0]));
            } else {
                responseHandler.accept((Object)context, (Object)true, (Object)langChannel.path("set.response").get(Component.m_237113_((String)newChannel).m_130940_(ChatFormatting.YELLOW)));
            }
            return 1;
        }));
        LiteralArgumentBuilder cmdConfig = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"config").executes(context -> {
            CommonClient.Game.m_6937_(() -> CommonClient.Game.m_91152_((Screen)new SettingsScreen()));
            return 1;
        });
        Command helpCallback = context -> {
            responseHandler.accept((Object)context, (Object)true, (Object)LanguageUtils.join(Component.m_237119_(), Component.m_237113_((String)"/pingwheel config"), LanguageUtils.wrapped(langConfig.path("description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel channel"), LanguageUtils.wrapped(langChannel.path("get.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"/pingwheel channel <channel_name>"), LanguageUtils.wrapped(langChannel.path("set.description").get(new Object[0])).m_130940_(ChatFormatting.GRAY)));
            return 1;
        };
        LiteralArgumentBuilder cmdHelp = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").executes(helpCallback);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"pingwheel").executes(helpCallback)).then((ArgumentBuilder)cmdHelp)).then((ArgumentBuilder)cmdConfig)).then((ArgumentBuilder)cmdChannel);
    }
}

