/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.compat.apotheosis.gem;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.item.ItemBonus;
import daripher.skilltree.skill.bonus.item.ItemSkillBonus;
import daripher.skilltree.skill.bonus.player.AttributeBonus;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PSTGemBonus
extends GemBonus {
    public static Codec<ItemBonus<?>> BONUS_CODEC = new Codec<ItemBonus<?>>(){

        public <T> DataResult<Pair<ItemBonus<?>, T>> decode(DynamicOps<T> ops, T input) {
            JsonObject json = ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject();
            ItemBonus<?> bonus = SerializationHelper.deserializeItemBonus(json);
            return DataResult.success((Object)Pair.of(bonus, input));
        }

        public <T> DataResult<T> encode(ItemBonus<?> input, DynamicOps<T> ops, T prefix) {
            JsonObject json = new JsonObject();
            SerializationHelper.serializeItemBonus(json, input);
            return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, (JsonElement)json));
        }
    };
    public static Codec<PSTGemBonus> CODEC = RecordCodecBuilder.create(i -> i.group(PSTGemBonus.gemClass(), (App)BONUS_CODEC.fieldOf("bonus").forGetter(b -> b.bonus)).apply((Applicative)i, PSTGemBonus::new));
    private ItemBonus<?> bonus;

    public PSTGemBonus(GemClass gemClass, ItemBonus<?> bonus) {
        super(new ResourceLocation("skilltree", "gem_bonus"), gemClass);
        this.bonus = bonus;
    }

    public PSTGemBonus copy() {
        return new PSTGemBonus(this.gemClass, (ItemBonus<?>)this.bonus.copy());
    }

    public PSTGemBonus multiply(float multiplier) {
        this.bonus = this.bonus.copy().multiply(multiplier);
        return this;
    }

    public ItemBonus<?> getBonus(ItemStack gemStack) {
        ItemSkillBonus aBonus;
        SkillBonus<?> skillBonus;
        Object bonus;
        float gemPower = 1.0f;
        CompoundTag tag = gemStack.m_41784_();
        if (tag.m_128441_("gem_power")) {
            gemPower = tag.m_128457_("gem_power");
        }
        if ((bonus = this.bonus.copy().multiply(gemPower)) instanceof ItemSkillBonus && (skillBonus = (aBonus = (ItemSkillBonus)bonus).getBonus()) instanceof AttributeBonus) {
            AttributeBonus atBonus = (AttributeBonus)skillBonus;
            atBonus.setUUID((UUID)GemItem.getUUIDs((ItemStack)gemStack).get(0));
        }
        return bonus;
    }

    public GemBonus validate() {
        Preconditions.checkNotNull(this.bonus, (Object)"Invalid PSTGemBonus with null bonus");
        return this;
    }

    public boolean supports(LootRarity lootRarity) {
        return true;
    }

    public int getNumberOfUUIDs() {
        return 1;
    }

    public Component getSocketBonusTooltip(ItemStack gemStack, LootRarity lootRarity) {
        float gemPower = 1.0f;
        CompoundTag tag = gemStack.m_41784_();
        if (tag.m_128441_("gem_power")) {
            gemPower = tag.m_128457_("gem_power");
        }
        Object bonus = this.bonus.copy().multiply(gemPower);
        return bonus.getTooltip().m_130948_(TooltipHelper.getSkillBonusStyle(bonus.isPositive()));
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

