/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.config.types;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import eu.gflash.notifmod.config.ConfigTypeBase;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

@JsonAdapter(value=Adapter.class)
public class SoundSequence
extends ConfigTypeBase {
    private static final Pattern NUM_PATTERN = Pattern.compile("^\\d+(\\.\\d+)?$");
    private static final Pattern SOUND_PATTERN = Pattern.compile("^(([^:()]+:)?[^:()]+)(\\((.+)\\))?$");
    private static final Pattern DELIMITER_PATTERN = Pattern.compile(";");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private final String sequenceStr;
    private final List<Sound> sequence = new ArrayList<Sound>();
    private String errorId = "";

    public SoundSequence(String ... sequence) {
        this(Strings.join((String[])sequence, (String)"; "));
    }

    public SoundSequence(String sequence) {
        this.sequenceStr = sequence;
        String noSpaceSequence = SPACE_PATTERN.matcher(sequence).replaceAll("");
        if (noSpaceSequence.isEmpty()) {
            return;
        }
        String[] entrySplit = DELIMITER_PATTERN.split(noSpaceSequence);
        for (int i = 0; i < entrySplit.length && this.error.isEmpty(); i += 2) {
            Matcher soundMatcher = SOUND_PATTERN.matcher(entrySplit[i]);
            if (soundMatcher.matches()) {
                float pitch = this.parseNum(soundMatcher.group(4), "invalidPitch", 1.0f);
                int delay = i + 1 < entrySplit.length - 1 ? (int)this.parseNum(entrySplit[i + 1], "invalidDelay", 0.0f) : 0;
                String id = soundMatcher.group(1);
                if (class_2960.method_20207((String)id)) {
                    class_7923.field_41172.method_17966(new class_2960(id)).ifPresentOrElse(soundEvent -> this.sequence.add(new Sound((class_3414)soundEvent, pitch, delay)), () -> this.setError("doesNotExist", id));
                    continue;
                }
                this.setError("invalidIdentifier", id);
                continue;
            }
            this.setError("invalidFormat", entrySplit[i]);
        }
    }

    public static SoundSequence getDefault() {
        return new SoundSequence("");
    }

    private float parseNum(String num, String err, float def) {
        if (num == null) {
            return def;
        }
        if (NUM_PATTERN.matcher(num).matches()) {
            return Float.parseFloat(num);
        }
        this.setError(err, num);
        return def;
    }

    private void setError(String err, String id) {
        this.error = err;
        this.errorId = id;
    }

    @Override
    protected class_2561 getUnsafeError() {
        return class_2561.method_43469((String)("error.config.notifmod.soundSequence." + this.error), (Object[])new Object[]{this.errorId});
    }

    public static Optional<class_2561> validate(String sequence) {
        return new SoundSequence(sequence).getError();
    }

    public void play(int volume) {
        this.play((float)volume / 100.0f);
    }

    public void play(float volume) {
        new Thread(() -> this.sequence.forEach(sound -> {
            sound.play(volume);
            try {
                Thread.sleep(sound.delay());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        })).start();
    }

    public String toString() {
        return this.sequenceStr;
    }

    private record Sound(class_3414 soundEvent, float pitch, int delay) {
        public void play(float volume) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null && mc.field_1687 != null) {
                mc.field_1687.method_43129((class_1657)mc.field_1724, (class_1297)mc.field_1724, this.soundEvent, class_3419.field_15250, volume, this.pitch);
            } else {
                mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)this.soundEvent, (float)this.pitch, (float)volume));
            }
        }
    }

    public static class Provider
    extends ConfigTypeBase.ProviderBase<String> {
        @Override
        public AbstractConfigListEntry<String> getEntry(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
            return ENTRY_BUILDER.startStrField((class_2561)class_2561.method_43471((String)i13n), ((SoundSequence)Utils.getUnsafely((Field)field, (Object)config, (Object)SoundSequence.getDefault())).toString()).setDefaultValue(() -> Utils.getUnsafely((Field)field, (Object)defaults).toString()).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)new SoundSequence((String)newValue))).setErrorSupplier(SoundSequence::validate).build();
        }
    }

    public static class Adapter
    extends TypeAdapter<SoundSequence> {
        public void write(JsonWriter out, SoundSequence value) throws IOException {
            out.value(value.toString());
        }

        public SoundSequence read(JsonReader in) throws IOException {
            return new SoundSequence(in.nextString());
        }
    }
}

