/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.config.types;

import com.google.common.collect.Lists;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import eu.gflash.notifmod.config.ConfigTypeBase;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@JsonAdapter(value=Adapter.class)
public class ItemList
extends ConfigTypeBase {
    private static final Pattern DELIMITER_PATTERN = Pattern.compile(";");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private final String itemListStr;
    private final List<String> itemList;
    private String errorId = "";

    public ItemList(String ... itemList) {
        this(Strings.join((String[])itemList, (String)"; "));
    }

    public ItemList(String itemList) {
        Object[] entrySplit;
        ArrayList itemIds;
        this.itemListStr = itemList;
        String noSpaceItemList = SPACE_PATTERN.matcher(itemList).replaceAll("");
        if (!noSpaceItemList.isEmpty() && (itemIds = Lists.newArrayList((Object[])(entrySplit = DELIMITER_PATTERN.split(noSpaceItemList)))).stream().noneMatch(id -> {
            if (class_2960.method_20207((String)id)) {
                if (class_7923.field_41178.method_10250(new class_2960(id))) {
                    return false;
                }
                this.setError("doesNotExist", (String)id);
            } else {
                this.setError("invalidIdentifier", (String)id);
            }
            return true;
        })) {
            this.itemList = itemIds;
            return;
        }
        this.itemList = new ArrayList<String>();
    }

    public static ItemList getDefault() {
        return new ItemList("");
    }

    private void setError(String err, String id) {
        this.error = err;
        this.errorId = id;
    }

    @Override
    protected class_2561 getUnsafeError() {
        return class_2561.method_43469((String)("error.config.notifmod.itemList." + this.error), (Object[])new Object[]{this.errorId});
    }

    public static Optional<class_2561> validate(String itemList) {
        return new ItemList(itemList).getError();
    }

    public boolean contains(class_1792 item) {
        return this.itemList.contains(class_7923.field_41178.method_10221((Object)item).toString());
    }

    public boolean contains(class_1799 itemStack) {
        return this.contains(itemStack.method_7909());
    }

    public String toString() {
        return this.itemListStr;
    }

    public static class Provider
    extends ConfigTypeBase.ProviderBase<String> {
        @Override
        public AbstractConfigListEntry<String> getEntry(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
            return ENTRY_BUILDER.startStrField((class_2561)class_2561.method_43471((String)i13n), ((ItemList)Utils.getUnsafely((Field)field, (Object)config, (Object)ItemList.getDefault())).toString()).setDefaultValue(() -> Utils.getUnsafely((Field)field, (Object)defaults).toString()).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)new ItemList((String)newValue))).setErrorSupplier(ItemList::validate).build();
        }
    }

    public static class Adapter
    extends TypeAdapter<ItemList> {
        public void write(JsonWriter out, ItemList value) throws IOException {
            out.value(value.toString());
        }

        public ItemList read(JsonReader in) throws IOException {
            return new ItemList(in.nextString());
        }
    }
}

