/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.config;

import com.google.gson.Gson;
import eu.gflash.notifmod.config.ConfigTypeBase;
import eu.gflash.notifmod.config.types.ItemList;
import eu.gflash.notifmod.config.types.Key;
import eu.gflash.notifmod.config.types.RegExPattern;
import eu.gflash.notifmod.config.types.SoundSequence;
import eu.gflash.notifmod.util.ItemUtil;
import eu.gflash.notifmod.util.Log;
import eu.gflash.notifmod.util.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.ImmutablePair;

@Config(name="notifmod")
@Config.Gui.Background(value="minecraft:textures/block/note_block.png")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static Map originalJson;
    @ConfigEntry.Gui.CollapsibleObject
    public Durability durability = new Durability();
    @ConfigEntry.Gui.CollapsibleObject
    public Chat chat = new Chat();
    @ConfigEntry.Gui.CollapsibleObject
    public PlayerJoinLeave playerJoinLeave = new PlayerJoinLeave();
    @ConfigEntry.Gui.CollapsibleObject
    public SleepReminder sleepReminder = new SleepReminder();
    @ConfigEntry.Gui.CollapsibleObject
    public DoneLoading doneLoading = new DoneLoading();
    @ConfigEntry.Gui.CollapsibleObject
    public Reminder reminder = new Reminder();

    public static void register() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        GuiRegistry registry = AutoConfig.getGuiRegistry(ModConfig.class);
        registry.registerTypeProvider((GuiProvider)new Key.Provider(), new Class[]{Key.class});
        registry.registerTypeProvider((GuiProvider)new RegExPattern.Provider(), new Class[]{RegExPattern.class});
        registry.registerTypeProvider((GuiProvider)new SoundSequence.Provider(), new Class[]{SoundSequence.class});
        registry.registerTypeProvider((GuiProvider)new ItemList.Provider(), new Class[]{ItemList.class});
    }

    public static ConfigHolder<ModConfig> getHolder() {
        return AutoConfig.getConfigHolder(ModConfig.class);
    }

    public static ModConfig getInstance() {
        return (ModConfig)ModConfig.getHolder().getConfig();
    }

    private static Path getConfigPath() {
        return Utils.getConfigFolder().resolve(ModConfig.class.getAnnotation(Config.class).name() + ".json");
    }

    private static <C> boolean updateConfig(C root, C defaults, @Nonnull Map<?, ?> json, String path) {
        return Setting.forEach(root, defaults, json, path, setting -> {
            if (!setting.hasJson()) {
                Log.debug("Settings: adding new field (path: " + setting.path + ")!");
                setting.reset();
            } else if (setting.isCategory()) {
                Object patt5073$temp = setting.jsonCurr;
                if (patt5073$temp instanceof Map) {
                    Map jc = (Map)patt5073$temp;
                    return ModConfig.updateConfig(setting.curr, setting.def, jc, setting.path + ".");
                }
                Log.debug("Settings: field changed to category in this version, resetting (path: " + setting.path + ")!");
                setting.reset();
            } else {
                return false;
            }
            return true;
        });
    }

    private <C> boolean validatePostLoad(C root, C defaults, String path) {
        return Setting.forEach(root, defaults, path, setting -> {
            if (setting.isNull()) {
                Log.debug("Settings: resetting missing/invalid field (path: " + setting.path + ")!");
                setting.reset();
            } else {
                Object patt6308$temp = setting.curr;
                if (patt6308$temp instanceof Integer) {
                    Integer c = (Integer)patt6308$temp;
                    Optional<ImmutablePair<Long, Long>> bounds = setting.bounds();
                    if (bounds.isEmpty()) {
                        return false;
                    }
                    int n = bounds.map(b -> (int)class_3532.method_15363((float)c.intValue(), (float)((Long)b.left).longValue(), (float)((Long)b.right).longValue())).get();
                    if (n == c) {
                        return false;
                    }
                    Log.debug("Settings: adjusting out of bounds number (path: " + setting.path + ", value: " + c + " -> " + n + ")!");
                    setting.set(n);
                } else {
                    ConfigTypeBase c;
                    Object patt6798$temp = setting.curr;
                    if (patt6798$temp instanceof ConfigTypeBase && (c = (ConfigTypeBase)patt6798$temp).hasError()) {
                        Log.debug("Settings: resetting invalid field (path: " + setting.path + ", error: " + c.getError() + ")!");
                        setting.reset();
                    } else {
                        if (setting.curr instanceof Number) {
                            throw new NotImplementedException("Config validation currently only supports integer numbers, pls fix (path: " + setting.path + ")!");
                        }
                        if (setting.isCategory()) {
                            return this.validatePostLoad(setting.curr, setting.def, setting.path + ".");
                        }
                        return false;
                    }
                }
            }
            return true;
        });
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        ModConfig def = new ModConfig();
        if (originalJson != null) {
            Log.info("Updating config...");
            Log.info("Config " + (ModConfig.updateConfig(this, def, originalJson, "") ? "updated." : "already up to date."));
            originalJson = null;
        }
        Log.info("Validating config...");
        super.validatePostLoad();
        if (this.validatePostLoad(this, def, "")) {
            Log.warn("Config repaired.");
        } else {
            Log.info("Config valid.");
        }
    }

    static {
        Path configPath = ModConfig.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                originalJson = (Map)new Gson().fromJson((Reader)reader, Map.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Durability {
        public boolean enabled = true;
        @ConfigEntry.Gui.Tooltip
        public ItemList trackedItems = new ItemList("minecraft:elytra", "minecraft:turtle_helmet", "minecraft:trident", ItemUtil.getArmor("chainmail"), ItemUtil.getArmor("diamond"), ItemUtil.getTools("diamond"), ItemUtil.getArmor("netherite"), ItemUtil.getTools("netherite"));
        @ConfigEntry.Gui.Tooltip
        public boolean alwaysNamed = true;
        @ConfigEntry.Gui.Tooltip
        public boolean alwaysEnchanted = true;
        @ConfigEntry.Gui.Tooltip
        public ItemList blacklistedEnchantedItems = ItemList.getDefault();
        @ConfigEntry.Gui.Tooltip
        public ItemList unbreakableItems = new ItemList("minecraft:elytra");
        @ConfigEntry.Gui.CollapsibleObject
        public Damage damageSettings = new Damage();
        @ConfigEntry.Gui.CollapsibleObject
        public Repair repairSettings = new Repair();

        public static class Damage {
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int damageThreshold = 5;
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int weakDamageThreshold = 10;
            @ConfigEntry.Gui.Tooltip
            @SimpleBoundedDiscrete
            public int weakThreshold = 120;
            @ConfigEntry.Gui.CollapsibleObject
            public Sub damage = new Sub("notifmod:durability.damage");
            @ConfigEntry.Gui.CollapsibleObject
            public Sub stop = new Sub("notifmod:durability.stop; 200; notifmod:durability.stop");

            public static class Sub
            implements SimpleAudibleTextNotif {
                @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
                public Message.Type msgType = Message.Type.CHAT;
                public boolean soundEnabled = false;
                @ConfigEntry.Gui.Tooltip
                public SoundSequence soundSequence;
                @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
                public int volume = 100;

                public Sub(String ... defSoundSeq) {
                    this.soundSequence = new SoundSequence(defSoundSeq);
                }

                @Override
                public Message.Type getMsgType() {
                    return this.msgType;
                }

                @Override
                public boolean isSoundEnabled() {
                    return this.soundEnabled;
                }

                @Override
                public SoundSequence getSoundSequence() {
                    return this.soundSequence;
                }

                @Override
                public int getVolume() {
                    return this.volume;
                }
            }
        }

        public static class Repair
        implements SimpleAudibleTextNotif {
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int unlockThreshold = 75;
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public Message.Type msgType = Message.Type.CHAT;
            public boolean soundEnabled = false;
            @ConfigEntry.Gui.Tooltip
            public SoundSequence soundSequence = new SoundSequence("notifmod:durability.mend(1.1)");
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int volume = 100;

            @Override
            public Message.Type getMsgType() {
                return this.msgType;
            }

            @Override
            public boolean isSoundEnabled() {
                return this.soundEnabled;
            }

            @Override
            public SoundSequence getSoundSequence() {
                return this.soundSequence;
            }

            @Override
            public int getVolume() {
                return this.volume;
            }
        }
    }

    public static class Chat {
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.CollapsibleObject
        public Sub message = new Sub(".+", ".+", "", "notifmod:chat.message");
        @ConfigEntry.Gui.CollapsibleObject
        public Sub mention = new Sub(".*\\p.*", ".*\\p.*", "", "notifmod:chat.mention");
        @ConfigEntry.Gui.Tooltip
        public boolean LogMsgInfo = false;

        public static class Sub
        implements AudibleNotif {
            public boolean enabled = true;
            @ConfigEntry.Gui.Tooltip
            public RegExPattern regexFilter;
            @ConfigEntry.Gui.Tooltip
            public RegExPattern regexFilterSys;
            @ConfigEntry.Gui.Tooltip
            public RegExPattern regexFilterGame;
            @ConfigEntry.Gui.Tooltip
            @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
            public Message.ChannelCombo caseSens = Message.ChannelCombo.NONE;
            @ConfigEntry.Gui.Tooltip
            public SoundSequence soundSequence;
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int volume = 100;

            public Sub(String defRegExFilter, String defRegExFilterSys, String defRegExFilterGame, String ... defSoundSeq) {
                this.regexFilter = new RegExPattern(defRegExFilter);
                this.regexFilterSys = new RegExPattern(defRegExFilterSys);
                this.regexFilterGame = new RegExPattern(defRegExFilterGame);
                this.soundSequence = new SoundSequence(defSoundSeq);
            }

            public boolean isCaseSens(Message.Channel channel) {
                int cso = this.caseSens.ordinal();
                return switch (channel) {
                    default -> throw new IncompatibleClassChangeError();
                    case Message.Channel.CHAT -> {
                        if (cso % 2 == 1) {
                            yield true;
                        }
                        yield false;
                    }
                    case Message.Channel.SYSTEM -> {
                        if (cso / 2 % 2 == 1) {
                            yield true;
                        }
                        yield false;
                    }
                    case Message.Channel.GAME_INFO -> cso / 4 == 1;
                };
            }

            public RegExPattern getRelevantPattern(Message.Channel channel) {
                return (switch (channel) {
                    default -> throw new IncompatibleClassChangeError();
                    case Message.Channel.CHAT -> this.regexFilter;
                    case Message.Channel.SYSTEM -> this.regexFilterSys;
                    case Message.Channel.GAME_INFO -> this.regexFilterGame;
                }).setCaseSensitivity(this.isCaseSens(channel));
            }

            public boolean relevantPatternMatches(Message.Channel channel, String message) {
                return this.getRelevantPattern(channel).matches(message);
            }

            @Override
            public boolean isSoundEnabled() {
                return this.enabled;
            }

            @Override
            public SoundSequence getSoundSequence() {
                return this.soundSequence;
            }

            @Override
            public int getVolume() {
                return this.volume;
            }
        }
    }

    public static class PlayerJoinLeave {
        @ConfigEntry.Gui.CollapsibleObject
        public Sound join = new Sound("notifmod:player.join(1.3)");
        @ConfigEntry.Gui.CollapsibleObject
        public Sound leave = new Sound("notifmod:player.leave(1.3)");

        public static class Sound
        implements AudibleNotif {
            public boolean enabled = true;
            @ConfigEntry.Gui.Tooltip
            public SoundSequence soundSequence;
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int volume = 100;

            public Sound(String ... defSoundSeq) {
                this.soundSequence = new SoundSequence(defSoundSeq);
            }

            @Override
            public boolean isSoundEnabled() {
                return this.enabled;
            }

            @Override
            public SoundSequence getSoundSequence() {
                return this.soundSequence;
            }

            @Override
            public int getVolume() {
                return this.volume;
            }
        }
    }

    public static class SleepReminder
    implements SimpleAudibleTextNotif {
        @ConfigEntry.Gui.PrefixText
        public boolean enabled = false;
        public boolean includeThunder = true;
        @ConfigEntry.Gui.CollapsibleObject
        public Conditions conditions = new Conditions();
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Message.Type msgType = Message.Type.CHAT;
        public boolean soundEnabled = false;
        @ConfigEntry.Gui.Tooltip
        public SoundSequence soundSequence = new SoundSequence("notifmod:sleep.now");
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int volume = 100;

        @Override
        public Message.Type getMsgType() {
            return this.msgType;
        }

        @Override
        public boolean isSoundEnabled() {
            return this.soundEnabled;
        }

        @Override
        public SoundSequence getSoundSequence() {
            return this.soundSequence;
        }

        @Override
        public int getVolume() {
            return this.volume;
        }

        public static class Conditions {
            @ConfigEntry.Gui.Tooltip
            public boolean pauseInTimelessDims = true;
            @ConfigEntry.Gui.Tooltip
            public boolean pauseUnderground = true;
            public int minAltitude = 50;
            @ConfigEntry.BoundedDiscrete(min=1L, max=15L)
            public int minSkyLight = 1;
            @ConfigEntry.Gui.Tooltip
            @SimpleBoundedDiscrete
            public int cooldown = 120;
        }
    }

    public static class DoneLoading {
        @ConfigEntry.Gui.CollapsibleObject
        public Game game = new Game("notifmod:done_loading.game");
        @ConfigEntry.Gui.CollapsibleObject
        public World world = new World("notifmod:done_loading.world");

        public static class Game
        implements AudibleNotif {
            public boolean enabled = false;
            @ConfigEntry.Gui.Tooltip
            public boolean afterFade = true;
            @ConfigEntry.Gui.Tooltip
            public SoundSequence soundSequence;
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int volume = 100;

            public Game(String ... defSoundSeq) {
                this.soundSequence = new SoundSequence(defSoundSeq);
            }

            @Override
            public boolean isSoundEnabled() {
                return this.enabled;
            }

            @Override
            public SoundSequence getSoundSequence() {
                return this.soundSequence;
            }

            @Override
            public int getVolume() {
                return this.volume;
            }
        }

        public static class World
        implements AudibleNotif {
            public boolean enabled = false;
            @ConfigEntry.Gui.Tooltip
            @SimpleBoundedDiscrete
            public int chunks = 9;
            @ConfigEntry.Gui.Tooltip
            public SoundSequence soundSequence;
            @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
            public int volume = 100;

            public World(String ... defSoundSeq) {
                this.soundSequence = new SoundSequence(defSoundSeq);
            }

            @Override
            public boolean isSoundEnabled() {
                return this.enabled;
            }

            @Override
            public SoundSequence getSoundSequence() {
                return this.soundSequence;
            }

            @Override
            public int getVolume() {
                return this.volume;
            }
        }
    }

    public static class Reminder
    implements AudibleNotif {
        @ConfigEntry.Gui.Tooltip
        public Key keyBind = new Key(334);
        @ConfigEntry.Gui.Tooltip
        public Key keyBindNoGUI = new Key(-1);
        @ConfigEntry.Gui.Tooltip
        @SimpleBoundedDiscrete
        public int defSeconds = 300;
        @ConfigEntry.Gui.Tooltip
        @SimpleBoundedDiscrete
        public int pre1Seconds = 120;
        @ConfigEntry.Gui.Tooltip
        @SimpleBoundedDiscrete
        public int pre2Seconds = 1200;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Message.Type msgTypeStart = Message.Type.ACTIONBAR;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Message.Type msgTypeDone = Message.Type.CHAT;
        public boolean soundEnabled = true;
        @ConfigEntry.Gui.Tooltip
        public SoundSequence soundSequence = new SoundSequence("notifmod:reminder.done");
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int volume = 100;

        @Override
        public boolean isSoundEnabled() {
            return this.soundEnabled;
        }

        @Override
        public SoundSequence getSoundSequence() {
            return this.soundSequence;
        }

        @Override
        public int getVolume() {
            return this.volume;
        }
    }

    private record Setting<C>(Field field, C currObj, Object curr, Object def, Object jsonCurr, String path) {
        public Setting(Field field, C currObj, C defObj, String path) throws IllegalAccessException {
            this(field, currObj, defObj, null, path);
        }

        public Setting(Field field, C currObj, C defObj, Map<?, ?> json, String path) throws IllegalAccessException {
            this(field, currObj, field.get(currObj), field.get(defObj), json == null ? null : json.get(field.getName()), path + field.getName());
        }

        public void set(Object n) {
            try {
                this.field.set(this.currObj, n);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public void reset() {
            this.set(this.def);
        }

        public boolean isNull() {
            return this.curr == null;
        }

        public boolean isCategory() {
            return this.field.isAnnotationPresent(ConfigEntry.Gui.CollapsibleObject.class);
        }

        public boolean hasJson() {
            return this.jsonCurr != null;
        }

        public Optional<ImmutablePair<Long, Long>> bounds() {
            return BoundMap.get(this.field);
        }

        public static <C> boolean forEach(C root, C defaults, String path, Predicate<Setting<C>> predicate) {
            return Setting.forEach(root, defaults, null, path, predicate);
        }

        public static <C> boolean forEach(C root, C defaults, @Nullable Map<?, ?> json, String path, Predicate<Setting<C>> predicate) {
            return Arrays.stream(root.getClass().getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isFinal(field.getModifiers())).filter(field -> !field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class)).map(field -> {
                try {
                    return new Setting<Object>((Field)field, root, defaults, json, path);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).filter(predicate).count() > 0L;
        }
    }

    private static class BoundMap {
        private static final Entry[] map = new Entry[]{BoundMap.add(ConfigEntry.BoundedDiscrete.class, a -> BoundMap.pair(a.min(), a.max())), BoundMap.add(SimpleBoundedDiscrete.class, a -> BoundMap.pair(a.min(), a.max()))};

        private BoundMap() {
        }

        public static Optional<ImmutablePair<Long, Long>> get(Field field) {
            return Arrays.stream(map).map(m -> m.map(field)).filter(Objects::nonNull).findFirst();
        }

        private static <A extends Annotation> Entry add(Class<A> annotationClass, Function<A, ImmutablePair<Long, Long>> mapper) {
            return new Entry(annotationClass, mapper);
        }

        private static ImmutablePair<Long, Long> pair(Long min, Long max) {
            return ImmutablePair.of((Object)min, (Object)max);
        }

        private record Entry(Class<? extends Annotation> annotationClass, Function<Annotation, ImmutablePair<Long, Long>> mapper) {
            public ImmutablePair<Long, Long> map(Field field) {
                return field.isAnnotationPresent(this.annotationClass) ? this.mapper.apply(field.getAnnotation(this.annotationClass)) : null;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SimpleBoundedDiscrete {
        public long min() default 0L;

        public long max() default 0x7FFFFFFFL;
    }

    public static interface AudibleNotif {
        public boolean isSoundEnabled();

        public SoundSequence getSoundSequence();

        public int getVolume();

        default public void playSound() {
            if (this.isSoundEnabled()) {
                this.getSoundSequence().play(this.getVolume());
            }
        }
    }

    public static interface SimpleTextNotif {
        public Message.Type getMsgType();

        default public void msg(Supplier<class_2561> msg) {
            this.getMsgType().msg(msg);
        }

        default public void msg(Supplier<class_2561> longMsg, Supplier<class_2561> shortMsg) {
            this.getMsgType().msg(longMsg, shortMsg);
        }

        default public void msgWithPre(Supplier<class_2561> msg) {
            this.getMsgType().msgWithPre(msg);
        }

        default public void msgWithPre(Supplier<class_2561> longMsg, Supplier<class_2561> shortMsg) {
            this.getMsgType().msgWithPre(longMsg, shortMsg);
        }
    }

    public static interface SimpleAudibleTextNotif
    extends AudibleNotif,
    SimpleTextNotif {
    }
}

