/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.client.listeners;

import eu.gflash.notifmod.config.ModConfig;
import eu.gflash.notifmod.util.TextUtil;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class WorldTimeListener {
    private static final class_2561 SLEEP_MSG = TextUtil.getWithFormat((class_2561)class_2561.method_43471((String)"msg.notifmod.sleep"), class_124.field_1075);
    private static final int CLEAR_SLEEP_TIME = 12542;
    private static final int RAINY_SLEEP_TIME = 12010;
    private static boolean notified = false;
    private static long lastNotifTime = 0L;

    public static void reset() {
        notified = false;
        lastNotifTime = 0L;
    }

    public static void onTimeUpdate(int timeOfDay, class_1937 world, class_1657 player, boolean isLoading) {
        if (isLoading) {
            return;
        }
        ModConfig.SleepReminder settings = ModConfig.getInstance().sleepReminder;
        if (!settings.enabled || System.currentTimeMillis() - lastNotifTime < (long)settings.conditions.cooldown * 1000L) {
            return;
        }
        if (notified) {
            WorldTimeListener.tryResetNotified(timeOfDay, world, player, settings);
        } else {
            WorldTimeListener.tryNotify(timeOfDay, world, player, settings);
        }
    }

    private static void tryResetNotified(int timeOfDay, class_1937 world, class_1657 player, ModConfig.SleepReminder settings) {
        if (WorldTimeListener.noNotify(timeOfDay, world, player, settings)) {
            notified = false;
        }
    }

    private static void tryNotify(int timeOfDay, class_1937 world, class_1657 player, ModConfig.SleepReminder settings) {
        if (WorldTimeListener.noNotify(timeOfDay, world, player, settings)) {
            return;
        }
        settings.msgWithPre(() -> SLEEP_MSG);
        settings.playSound();
        notified = true;
        lastNotifTime = System.currentTimeMillis();
    }

    private static boolean noNotify(int timeOfDay, class_1937 world, class_1657 player, ModConfig.SleepReminder settings) {
        ModConfig.SleepReminder.Conditions cSettings = settings.conditions;
        if (world.method_8597().method_29960() && cSettings.pauseInTimelessDims) {
            return true;
        }
        if (!(timeOfDay >= WorldTimeListener.getSleepTime(world) || settings.includeThunder && world.method_8546())) {
            return true;
        }
        if (!cSettings.pauseUnderground) {
            return false;
        }
        class_2338 pos = player.method_24515();
        return pos.method_10264() < cSettings.minAltitude && WorldTimeListener.getSkyLL(world, pos) < cSettings.minSkyLight;
    }

    private static int getSleepTime(class_1937 world) {
        if (world.method_8419()) {
            return 12010;
        }
        return 12542;
    }

    private static int getSkyLL(class_1937 world, class_2338 pos) {
        return world.method_8314(class_1944.field_9284, pos);
    }
}

