/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.client.listeners;

import eu.gflash.notifmod.config.ModConfig;

public class WorldLoadListener {
    private static int chunkCounter = 0;
    private static boolean notified = false;

    public static void onLoad() {
        ModConfig.DoneLoading.World settings = ModConfig.getInstance().doneLoading.world;
        if (settings.enabled) {
            if (settings.chunks <= 0) {
                WorldLoadListener.notify(settings);
            }
        } else {
            notified = true;
        }
    }

    public static void onChunkBuild() {
        if (notified) {
            return;
        }
        ModConfig.DoneLoading.World settings = ModConfig.getInstance().doneLoading.world;
        if (settings.enabled && ++chunkCounter >= settings.chunks) {
            WorldLoadListener.notify(settings);
        }
    }

    public static void reset() {
        chunkCounter = 0;
        notified = false;
    }

    private static void notify(ModConfig.DoneLoading.World settings) {
        notified = true;
        settings.playSound();
    }
}

