/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.client.listeners;

import eu.gflash.notifmod.config.ModConfig;
import eu.gflash.notifmod.util.Log;
import eu.gflash.notifmod.util.Message;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class MessageListener {
    public static void onMessage(Message.Incoming msg) {
        class_746 player = class_310.method_1551().field_1724;
        if (!(player == null || msg.hasSender() && msg.senderIs((class_1657)player) || msg.isEmpty())) {
            MessageListener.onIncomingMessage(msg.channel(), msg.toString());
        }
    }

    private static void onIncomingMessage(Message.Channel channel, String message) {
        ModConfig.Chat settings = ModConfig.getInstance().chat;
        boolean logInfo = settings.LogMsgInfo;
        if (MessageListener.tryNotify(settings.mention, channel, message, "mention", logInfo)) {
            return;
        }
        if (MessageListener.tryNotify(settings.message, channel, message, "message", logInfo)) {
            return;
        }
        if (logInfo) {
            Log.info("Incoming non-matching message (" + channel + ", " + (settings.message.isCaseSens(channel) ? "case-sens" : "case-insens") + " messages, " + (settings.mention.isCaseSens(channel) ? "case-sens" : "case-insens") + " mentions): " + message);
        }
    }

    private static boolean tryNotify(ModConfig.Chat.Sub settings, Message.Channel channel, String message, String type, boolean logInfo) {
        if (!settings.enabled || !settings.relevantPatternMatches(channel, message)) {
            return false;
        }
        settings.playSound();
        if (logInfo) {
            Log.info("Incoming matching message (" + channel + ", " + type + ", " + (settings.isCaseSens(channel) ? "case-sensitive" : "case-insensitive") + "): " + message);
        }
        return true;
    }
}

