/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.main;

import com.robertx22.library_of_exile.components.OnMobDamaged;
import com.robertx22.library_of_exile.database.affix.base.MobAffixEvents;
import com.robertx22.library_of_exile.events.ExileLibEvents;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.main.Capabilities;
import com.robertx22.library_of_exile.main.ClientInit;
import com.robertx22.library_of_exile.main.LibDataGen;
import com.robertx22.library_of_exile.main.LibModConstructor;
import com.robertx22.library_of_exile.main.LibWords;
import com.robertx22.library_of_exile.registers.client.S2CPacketRegister;
import com.robertx22.library_of_exile.registers.common.C2SPacketRegister;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistryEvent;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.SyncTime;
import com.robertx22.library_of_exile.registry.helpers.OrderedModConstructor;
import com.robertx22.library_of_exile.registry.util.ExileRegistryUtil;
import com.robertx22.library_of_exile.unidentified.IdentifiableItems;
import com.robertx22.library_of_exile.util.wiki.WikiEntryCommands;
import com.robertx22.orbs_of_crafting.main.OrbsOfCraftingMain;
import com.robertx22.orbs_of_crafting.misc.OnClick;
import com.robertx22.orbs_of_crafting.register.ExileCurrency;
import com.robertx22.orbs_of_crafting.register.Orbs;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="library_of_exile")
public class CommonInit {
    public static boolean RUN_DEV_TOOLS = false;
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"library_of_exile");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"library_of_exile");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"library_of_exile");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TAB = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"library_of_exile");
    static Lock lock = new ReentrantLock();

    public static void initDeferred() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        CREATIVE_TAB.register(bus);
        BLOCKS.register(bus);
        BLOCK_ENTITIES.register(bus);
        CREATIVE_TAB.register("tab", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 2).m_257737_(() -> Orbs.INSTANCE.LEGENDARY_TOOL_ENCHANT.getItem().m_7968_()).m_257941_((Component)LibWords.MOD_NAME.get(new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD})).m_257501_(new CreativeModeTab.DisplayItemsGenerator(){

            public void m_257865_(CreativeModeTab.ItemDisplayParameters param, CreativeModeTab.Output output) {
                for (Item item : ExileCurrency.CACHED_MAP.get().keySet()) {
                    output.m_246326_((ItemLike)item);
                }
            }
        }).m_257652_());
    }

    public static void registerEntries() {
    }

    public CommonInit() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        OrderedModConstructor.register(new LibModConstructor("library_of_exile"), bus);
        OrbsOfCraftingMain.init(bus);
        if (RUN_DEV_TOOLS) {
            ExileRegistryUtil.setCurrentRegistarMod("library_of_exile");
            ApiForgeEvents.registerForgeEvent(PlayerEvent.PlayerLoggedInEvent.class, event -> {
                new LibDataGen().m_213708_(CachedOutput.f_236016_);
                event.getEntity().m_213846_((Component)Component.m_237113_((String)"WARNING: Dev tools ON!"));
            });
        }
        bus.addListener(this::commonSetupEvent);
        bus.addListener(this::interMod);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        ApiForgeEvents.register();
        ApiForgeEvents.registerForgeEvent(OnDatapackSyncEvent.class, x -> {
            ServerPlayer player = x.getPlayer();
            Database.sendPacketsToClient(player, SyncTime.ON_LOGIN);
        });
        MobAffixEvents.init();
        C2SPacketRegister.register();
        S2CPacketRegister.register();
        ExileLibEvents.init();
        IdentifiableItems.init();
        ExileEvents.DAMAGE_AFTER_CALC.register(new OnMobDamaged());
        ApiForgeEvents.registerForgeEvent(LivingDeathEvent.class, x -> {
            LivingEntity patt5989$temp = x.getEntity();
            if (patt5989$temp instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)patt5989$temp;
                ExileEvents.PLAYER_DEATH.callEvents(new ExileEvents.OnPlayerDeath((Player)p));
            }
        }, EventPriority.LOWEST);
        ApiForgeEvents.registerForgeEvent(AddReloadListenerEvent.class, event -> ExileRegistryType.registerJsonListeners(event));
        ApiForgeEvents.registerForgeEvent(RegisterCommandsEvent.class, event -> WikiEntryCommands.init(event.getDispatcher()));
        OnClick.register();
    }

    public static String defaultConfigName(ModConfig.Type type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.extension());
    }

    public void interMod(InterModProcessEvent event) {
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        for (ExileRegistryType type : ExileRegistryType.getAllInRegisterOrder()) {
            ExileRegistryEvent e = new ExileRegistryEvent(type);
            ExileEvents.EXILE_REGISTRY_GATHER.callEvents(e);
        }
        Capabilities.reg();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ClientInit.onInitializeClient();
    }

    public static void onDatapacksReloaded() {
        try {
            lock.lock();
            try {
                Database.checkGuidValidity();
                Database.unregisterInvalidEntries();
                Database.getAllRegistries().forEach(x -> x.onAllDatapacksLoaded());
                ExileEvents.AFTER_DATABASE_LOADED.callEvents(new ExileEvents.AfterDatabaseLoaded());
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

