/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension.structure.dungeon;

import com.robertx22.library_of_exile.dimension.structure.dungeon.BuiltDungeon;
import com.robertx22.library_of_exile.dimension.structure.dungeon.BuiltRoom;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonRoom;
import com.robertx22.library_of_exile.dimension.structure.dungeon.IDungeon;
import com.robertx22.library_of_exile.dimension.structure.dungeon.RoomRotation;
import com.robertx22.library_of_exile.dimension.structure.dungeon.RoomType;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DungeonBuilder {
    public IDungeon dungeon;
    public BuiltDungeon builtDungeon;
    public final Random rand;
    public int size;

    public DungeonBuilder(Settings settings) {
        this.rand = settings.ran;
        this.dungeon = RandomUtils.weightedRandom(settings.possibleDungeons, this.rand.nextDouble());
        this.size = RandomUtils.RandomRange(settings.minRooms, settings.maxRooms, this.rand);
    }

    public void build() {
        this.builtDungeon = new BuiltDungeon(this.size, this);
        this.builtDungeon.setupBarriers();
        this.setupEntrance();
        this.builtDungeon.fillWithBarriers();
    }

    public RoomRotation random(List<RoomRotation> list) {
        return RandomUtils.weightedRandom(list, this.rand.nextDouble());
    }

    private void setupEntrance() {
        DungeonRoom entranceRoom = RoomType.ENTRANCE.getRandomRoom(this.dungeon, this);
        ArrayList<RoomRotation> possible = new ArrayList<RoomRotation>();
        possible.addAll(RoomType.ENTRANCE.getRotations());
        RoomRotation rotation = this.random(possible);
        BuiltRoom entrance = new BuiltRoom(rotation, entranceRoom);
        int mid = this.builtDungeon.getMiddle();
        this.builtDungeon.addRoom(mid, mid, entrance);
    }

    public static class Settings {
        public Random ran;
        public int minRooms;
        public int maxRooms;
        public List<IDungeon> possibleDungeons;

        public Settings(Random ran, int minRooms, int maxRooms, List<IDungeon> possibleDungeons) {
            this.ran = ran;
            this.minRooms = minRooms;
            this.maxRooms = maxRooms;
            this.possibleDungeons = possibleDungeons;
        }
    }
}

