/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension.structure.dungeon;

import com.google.common.base.Preconditions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.dimension.structure.dungeon.BuiltRoom;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonBuilder;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonRoom;
import com.robertx22.library_of_exile.dimension.structure.dungeon.RoomRotation;
import com.robertx22.library_of_exile.dimension.structure.dungeon.RoomSide;
import com.robertx22.library_of_exile.dimension.structure.dungeon.RoomSides;
import com.robertx22.library_of_exile.dimension.structure.dungeon.RoomType;
import com.robertx22.library_of_exile.dimension.structure.dungeon.UnbuiltRoom;
import com.robertx22.library_of_exile.util.PointData;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;

public class BuiltDungeon {
    public DungeonBuilder b;
    int capacity;
    private int size;
    private boolean started = false;
    public int amount = 0;
    int ends = 0;
    private BuiltRoom[][] rooms;
    public boolean startFinishing = false;

    public BuiltDungeon(int size, DungeonBuilder b) {
        this(size, 20);
        this.b = b;
    }

    public BuiltDungeon(int size, int capacity) {
        this.size = size;
        this.capacity = capacity;
        this.rooms = new BuiltRoom[capacity][capacity];
    }

    public BuiltRoom[][] getRooms() {
        return this.rooms;
    }

    public boolean shouldStartFinishing(PointData point) {
        if (this.startFinishing) {
            return this.startFinishing;
        }
        if (this.isTooCloseToGridEdge(point)) {
            return true;
        }
        return this.amount > this.size;
    }

    public boolean isTooCloseToGridEdge(PointData p) {
        int too = 3;
        return p.x < too || p.y < too || p.y > this.capacity - too || p.x > this.capacity - too;
    }

    public BuiltRoom getRoomForChunk(MapStructure s, ChunkPos pos) {
        try {
            ChunkPos start = s.getStartChunkPos(pos.m_151394_(50));
            ChunkPos relative = new ChunkPos(pos.f_45578_ - start.f_45578_, pos.f_45579_ - start.f_45579_);
            return this.rooms[this.getMiddle() + relative.f_45578_][this.getMiddle() + relative.f_45579_];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasRoomForChunk(MapStructure s, ChunkPos pos) {
        return this.getRoomForChunk(s, pos) != null;
    }

    public BuiltRoom getRoom(int x, int z) {
        if (!this.isWithinBounds(x, z)) {
            return null;
        }
        return this.rooms[x][z];
    }

    public boolean isWithinBounds(int x, int z) {
        return x + 1 <= this.capacity && z + 1 <= this.capacity && x >= 0 && z >= 0;
    }

    public int getMiddle() {
        return this.rooms.length / 2;
    }

    public PointData getCoordsOfRoomFacing(Direction dir, int x, int z) {
        if (dir == Direction.NORTH) {
            return new PointData(x, z - 1);
        }
        if (dir == Direction.SOUTH) {
            return new PointData(x, z + 1);
        }
        if (dir == Direction.EAST) {
            return new PointData(x + 1, z);
        }
        if (dir == Direction.WEST) {
            return new PointData(x - 1, z);
        }
        throw new RuntimeException("getCoordsOfRoomFacing is null? Wrong direction?");
    }

    public void setupBarriers() {
        BuiltRoom built = BuiltRoom.getBarrier();
        for (int i = 0; i < this.rooms.length; ++i) {
            for (int j = 0; j < this.rooms[i].length; ++j) {
                if (i != 0 && j != 0 && i != this.rooms.length - 1 && j != this.rooms[i].length - 1) continue;
                this.addBarrier(i, j, built);
            }
        }
    }

    public void fillWithBarriers() {
        BuiltRoom built = BuiltRoom.getBarrier();
        for (int i = 0; i < this.rooms.length; ++i) {
            for (int j = 0; j < this.rooms[i].length; ++j) {
                if (this.getRoom(i, j) != null || !this.hasRoomNearby(i, j)) continue;
                this.addBarrier(i, j, built);
            }
        }
    }

    public boolean hasRoomNearby(int x, int z) {
        List<Direction> dirs = Arrays.asList(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
        for (Direction dir : dirs) {
            BuiltRoom room = this.getRoomFacing(dir, x, z);
            if (room == null || room.room.isBarrier) continue;
            return true;
        }
        return false;
    }

    public BuiltRoom getRoomFacing(Direction dir, int x, int z) {
        PointData coords = this.getCoordsOfRoomFacing(dir, x, z);
        if (coords != null) {
            return this.getRoom(coords.x, coords.y);
        }
        throw new RuntimeException("getRoomFacing is null? Wrong direction?");
    }

    public RoomSide getSideOfRoomFacing(Direction dir, int x, int z) {
        BuiltRoom room = this.getRoomFacing(dir, x, z);
        if (dir == Direction.NORTH) {
            return room != null ? room.data.sides.SOUTH : RoomSide.UNBUILT;
        }
        if (dir == Direction.SOUTH) {
            return room != null ? room.data.sides.NORTH : RoomSide.UNBUILT;
        }
        if (dir == Direction.EAST) {
            return room != null ? room.data.sides.WEST : RoomSide.UNBUILT;
        }
        if (dir == Direction.WEST) {
            return room != null ? room.data.sides.EAST : RoomSide.UNBUILT;
        }
        throw new RuntimeException("No room found facing in direction of: " + dir.toString() + ": " + x + " , " + z);
    }

    public UnbuiltRoom getUnbuiltFor(int x, int z) {
        RoomSide S = this.getSideOfRoomFacing(Direction.SOUTH, x, z);
        RoomSide N = this.getSideOfRoomFacing(Direction.NORTH, x, z);
        RoomSide E = this.getSideOfRoomFacing(Direction.EAST, x, z);
        RoomSide W = this.getSideOfRoomFacing(Direction.WEST, x, z);
        RoomSides sides = new RoomSides(S, N, E, W);
        UnbuiltRoom unbuilt = new UnbuiltRoom(sides);
        return unbuilt;
    }

    private void buildConnectedRooms(int x, int z, BuiltRoom room) {
        List<Direction> dirs = room.data.sides.getDoorSides();
        dirs.forEach(dir -> {
            PointData coord = this.getCoordsOfRoomFacing((Direction)dir, x, z);
            if (this.getRoom(coord.x, coord.y) == null && this.isWithinBounds(coord.x, coord.y) && room.data.sides.getSideOfDirection((Direction)dir) == RoomSide.DOOR) {
                UnbuiltRoom unbuilt = this.getUnbuiltFor(coord.x, coord.y);
                Preconditions.checkNotNull((Object)unbuilt);
                RoomRotation rot = this.randomDungeonRoom(unbuilt, coord);
                Preconditions.checkNotNull((Object)rot);
                DungeonRoom dRoom = rot.type.getRandomRoom(this.b.dungeon, this.b);
                Preconditions.checkNotNull((Object)dRoom);
                BuiltRoom theroom = new BuiltRoom(rot, dRoom);
                Preconditions.checkNotNull((Object)theroom);
                this.addRoom(coord.x, coord.y, theroom);
            }
        });
    }

    public RoomRotation randomDungeonRoom(UnbuiltRoom unbuilt, PointData point) {
        if (this.shouldStartFinishing(point)) {
            List<RoomRotation> possible = this.tryEndRoom(unbuilt);
            if (!possible.isEmpty()) {
                return this.random(possible);
            }
            return this.randomRoom(unbuilt);
        }
        return this.randomRoom(unbuilt);
    }

    public List<RoomRotation> tryEndRoom(UnbuiltRoom unbuilt) {
        ArrayList<RoomType> types = new ArrayList<RoomType>();
        types.add(RoomType.END);
        types.add(RoomType.CURVED_HALLWAY);
        types.add(RoomType.STRAIGHT_HALLWAY);
        types.add(RoomType.TRIPLE_HALLWAY);
        for (RoomType type : types) {
            List<RoomRotation> possible = type.getPossibleFor(unbuilt);
            if (possible.isEmpty()) continue;
            return possible;
        }
        return Arrays.asList(new RoomRotation[0]);
    }

    public RoomRotation randomRoom(UnbuiltRoom unbuilt) {
        ArrayList<RoomType> types = new ArrayList<RoomType>();
        types.add(RoomType.CURVED_HALLWAY);
        types.add(RoomType.STRAIGHT_HALLWAY);
        types.add(RoomType.FOUR_WAY);
        types.add(RoomType.TRIPLE_HALLWAY);
        ArrayList<RoomRotation> possible = new ArrayList<RoomRotation>();
        types.forEach(x -> possible.addAll(x.getPossibleFor(unbuilt)));
        if (possible.isEmpty()) {
            possible.addAll(RoomType.END.getPossibleFor(unbuilt));
            if (possible.isEmpty()) {
                throw new RuntimeException("No possible rooms at all for unbuilt room, this is horrible.");
            }
        }
        return this.random(possible);
    }

    public RoomRotation random(List<RoomRotation> list) {
        return RandomUtils.weightedRandom(list, this.b.rand.nextDouble());
    }

    public void addBarrier(int x, int z, BuiltRoom room) {
        this.rooms[x][z] = room;
    }

    public void forceSetRoom(int x, int z, BuiltRoom room) {
        this.rooms[x][z] = room;
    }

    public void addRoom(int x, int z, BuiltRoom room) {
        if (room == null) {
            return;
        }
        if (this.getRoom(x, z) == null) {
            this.rooms[x][z] = room;
            ++this.amount;
            if (room.data.type.equals(RoomType.END)) {
                ++this.ends;
            }
            this.started = true;
            if (room.data.type != RoomType.END) {
                this.buildConnectedRooms(x, z, room);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuiltDungeon d = (BuiltDungeon)o;
        return d.amount == this.amount && d.ends == this.ends;
    }

    public int hashCode() {
        return Objects.hash(this);
    }
}

