/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension.structure;

import com.robertx22.library_of_exile.dimension.MapGenerationUTIL;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class MapStructure<Map> {
    public abstract String guid();

    public abstract Map getMap(ChunkPos var1);

    public abstract int getSpawnHeight();

    public final int getStructureHeight() {
        return 48;
    }

    public boolean isInside(ServerLevel level, BlockPos pos) {
        return pos.m_123342_() >= this.getSpawnHeight() && pos.m_123342_() <= this.getSpawnHeight() + this.getStructureHeight();
    }

    protected abstract ChunkPos INTERNALgetStartChunkPos(ChunkPos var1);

    public Random createRandom(Level level, ChunkPos cp) {
        return MapGenerationUTIL.createRandom(level, this.getStartChunkPos(cp));
    }

    public ChunkPos getStartChunkPos(ChunkPos cp) {
        ChunkPos start2;
        ChunkPos start = this.INTERNALgetStartChunkPos(cp);
        if (!start.equals((Object)(start2 = this.INTERNALgetStartChunkPos(start)))) {
            // empty if block
        }
        return start;
    }

    public ChunkPos getRelativeChunkPosFromStart(ChunkPos pos) {
        ChunkPos start = this.getStartChunkPos(pos);
        ChunkPos relative = new ChunkPos(pos.f_45578_ - start.f_45578_, pos.f_45579_ - start.f_45579_);
        return relative;
    }

    public ChunkPos getStartChunkPos(BlockPos pos) {
        ChunkPos start = this.getStartChunkPos(new ChunkPos(pos));
        return start;
    }

    public List<Player> getAllPlayersInMap(Level world, BlockPos pos) {
        ChunkPos start = this.getStartChunkPos(pos);
        return world.m_6907_().stream().filter(x -> this.getStartChunkPos(x.m_20183_()).equals((Object)start)).collect(Collectors.toList());
    }

    public abstract boolean generateInChunk(ServerLevelAccessor var1, StructureTemplateManager var2, ChunkPos var3);
}

