/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.structure.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.jadenxgamer.netherexp.registry.worldgen.structure.JNEStructureType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public class MegaFossilStructure
extends Structure {
    public static final Codec<MegaFossilStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MegaFossilStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, MegaFossilStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public MegaFossilStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        WorldgenRandom worldgenRandom = context.f_226626_();
        int x = context.f_226628_().m_45604_() + worldgenRandom.m_188503_(16);
        int z = context.f_226628_().m_45605_() + worldgenRandom.m_188503_(16);
        int sea = context.f_226622_().m_6337_();
        WorldGenerationContext worldGenerationContext = new WorldGenerationContext(context.f_226622_(), context.f_226629_());
        int y = this.startHeight.m_213859_((RandomSource)worldgenRandom, worldGenerationContext);
        NoiseColumn noiseColumn = context.f_226622_().m_214184_(x, z, context.f_226629_(), context.f_226624_());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (y > sea) {
            BlockState blockState = noiseColumn.m_183556_(y);
            BlockState blockState2 = noiseColumn.m_183556_(--y);
            if (!blockState.m_60795_() || !blockState2.m_60713_(Blocks.f_50135_) && !blockState2.m_60783_((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mutableBlockPos.m_142448_(y), Direction.UP)) continue;
            break;
        }
        if (y <= sea) {
            return Optional.empty();
        }
        BlockPos blockPos = new BlockPos(x, y, z);
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return (StructureType)JNEStructureType.MEGA_FOSSIL.get();
    }
}

