/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.structure.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.jadenxgamer.netherexp.registry.worldgen.structure.JNEStructureType;
import net.jadenxgamer.netherexp.registry.worldgen.structure.custom.GiantJigsawPlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public class GiantJigsawStructure
extends Structure {
    public static final Codec<GiantJigsawStructure> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)GiantJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(arg -> arg.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(arg -> arg.startJigsawName), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(arg -> arg.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(arg -> arg.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(arg -> arg.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(arg -> arg.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(arg -> arg.maxDistanceFromCenter)).apply((Applicative)instance, GiantJigsawStructure::new)), GiantJigsawStructure::verifyRange).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static DataResult<GiantJigsawStructure> verifyRange(GiantJigsawStructure arg) {
        int i = switch (arg.m_226620_()) {
            default -> throw new IncompatibleClassChangeError();
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
        };
        return arg.maxDistanceFromCenter + i > 256 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 256") : DataResult.success((Object)((Object)arg));
    }

    public GiantJigsawStructure(Structure.StructureSettings structure, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(structure);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public GiantJigsawStructure(Structure.StructureSettings structure, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Heightmap.Types projectStartToHeightmap) {
        this(structure, startPool, Optional.empty(), maxDepth, startHeight, useExpansionHack, Optional.of(projectStartToHeightmap), 240);
    }

    public GiantJigsawStructure(Structure.StructureSettings structure, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, boolean useExpansionHack) {
        this(structure, startPool, Optional.empty(), maxDepth, startHeight, useExpansionHack, Optional.empty(), 240);
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        int i = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), i, chunkPos.m_45605_());
        return GiantJigsawPlacement.addPieces(context, this.startPool, this.startJigsawName, this.maxDepth, blockPos, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter);
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return (StructureType)JNEStructureType.GIANT_JIGSAW.get();
    }
}

