/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.structure.custom;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class GiantJigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        BlockPos blockPos2;
        RegistryAccess registryAccess = context.f_226621_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        StructureTemplateManager structureTemplateManager = context.f_226625_();
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        WorldgenRandom worldgenRandom = context.f_226626_();
        Registry registry = registryAccess.m_175515_(Registries.f_256948_);
        Rotation rotation = Rotation.m_221990_((RandomSource)worldgenRandom);
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)startPool.m_203334_();
        StructurePoolElement structurePoolElement = structureTemplatePool.m_227355_((RandomSource)worldgenRandom);
        if (structurePoolElement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (startJigsawName.isPresent()) {
            ResourceLocation resourceLocation = startJigsawName.get();
            Optional<BlockPos> optional3 = GiantJigsawPlacement.getRandomNamedJigsaw(structurePoolElement, resourceLocation, pos, rotation, structureTemplateManager, worldgenRandom);
            if (optional3.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourceLocation, (Object)startPool.m_203543_().map(resourceKey -> resourceKey.m_135782_().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos2 = optional3.get();
        } else {
            blockPos2 = pos;
        }
        BlockPos vec3i = blockPos2.m_121996_((Vec3i)pos);
        BlockPos blockPos3 = pos.m_121996_((Vec3i)vec3i);
        PoolElementStructurePiece poolElementStructurePiece = new PoolElementStructurePiece(structureTemplateManager, structurePoolElement, blockPos3, structurePoolElement.m_210540_(), rotation, structurePoolElement.m_214015_(structureTemplateManager, blockPos3, rotation));
        BoundingBox boundingBox = poolElementStructurePiece.m_73547_();
        int k = (boundingBox.m_162399_() + boundingBox.m_162395_()) / 2;
        int l = (boundingBox.m_162401_() + boundingBox.m_162398_()) / 2;
        int m = projectStartToHeightmap.isPresent() ? pos.m_123342_() + chunkGenerator.m_223221_(k, l, projectStartToHeightmap.get(), levelHeightAccessor, context.f_226624_()) : blockPos3.m_123342_();
        int n = boundingBox.m_162396_() + poolElementStructurePiece.m_72647_();
        poolElementStructurePiece.m_6324_(0, m - n, 0);
        int o = m + vec3i.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(k, o, l), structurePiecesBuilder -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolElementStructurePiece);
            if (maxDepth > 0) {
                AABB aABB = new AABB((double)(k - maxDistanceFromCenter), (double)(o - 64), (double)(l - maxDistanceFromCenter), (double)(k + maxDistanceFromCenter + 1), (double)(o + 64 + 1), (double)(l + maxDistanceFromCenter + 1));
                VoxelShape voxelShape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aABB), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingBox)), (BooleanOp)BooleanOp.f_82685_);
                GiantJigsawPlacement.addPiecesChild(context.f_226624_(), maxDepth, useExpansionHack, chunkGenerator, structureTemplateManager, levelHeightAccessor, (RandomSource)worldgenRandom, (Registry<StructureTemplatePool>)registry, poolElementStructurePiece, list, voxelShape);
                Objects.requireNonNull(structurePiecesBuilder);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
            }
        }));
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement structurePoolElement, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation, StructureTemplateManager structureTemplateManager, WorldgenRandom worldgenRandom) {
        List list = structurePoolElement.m_213638_(structureTemplateManager, blockPos, rotation, (RandomSource)worldgenRandom);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list) {
            ResourceLocation resourceLocation2 = ResourceLocation.m_135820_((String)structureBlockInfo.f_74677_().m_128461_("name"));
            if (!resourceLocation.equals((Object)resourceLocation2)) continue;
            optional = Optional.of(structureBlockInfo.f_74675_());
            break;
        }
        return optional;
    }

    private static void addPiecesChild(RandomState randomState, int i, boolean bl, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor levelHeightAccessor, RandomSource randomSource, Registry<StructureTemplatePool> registry, PoolElementStructurePiece poolElementStructurePiece, List<PoolElementStructurePiece> list, VoxelShape voxelShape) {
        Placer placer = new Placer(registry, i, chunkGenerator, structureTemplateManager, list, randomSource);
        placer.placing.addLast(new PieceState(poolElementStructurePiece, (MutableObject<VoxelShape>)new MutableObject((Object)voxelShape), 0));
        while (!placer.placing.isEmpty()) {
            PieceState pieceState = placer.placing.removeFirst();
            placer.tryPlacingChildren(pieceState.piece, pieceState.free, pieceState.depth, bl, levelHeightAccessor, randomState);
        }
    }

    public static boolean generateJigsaw(ServerLevel serverLevel, Holder<StructureTemplatePool> holder, ResourceLocation resourceLocation, int i, BlockPos blockPos, boolean bl) {
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        StructureTemplateManager structureTemplateManager = serverLevel.m_215082_();
        StructureManager structureManager = serverLevel.m_215010_();
        RandomSource randomSource = serverLevel.m_213780_();
        Structure.GenerationContext generationContext = new Structure.GenerationContext(serverLevel.m_9598_(), chunkGenerator, chunkGenerator.m_62218_(), serverLevel.m_7726_().m_214994_(), structureTemplateManager, serverLevel.m_7328_(), new ChunkPos(blockPos), (LevelHeightAccessor)serverLevel, holderx -> true);
        Optional<Structure.GenerationStub> optional = GiantJigsawPlacement.addPieces(generationContext, holder, Optional.of(resourceLocation), i, blockPos, false, Optional.empty(), 512);
        if (optional.isPresent()) {
            StructurePiecesBuilder structurePiecesBuilder = optional.get().m_226677_();
            for (StructurePiece structurePiece : structurePiecesBuilder.m_192780_().f_192741_()) {
                if (!(structurePiece instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece poolElementStructurePiece = (PoolElementStructurePiece)structurePiece;
                poolElementStructurePiece.m_226509_((WorldGenLevel)serverLevel, structureManager, chunkGenerator, randomSource, BoundingBox.m_71044_(), blockPos, bl);
            }
            return true;
        }
        return false;
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> registry, int i, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> list, RandomSource randomSource) {
            this.pools = registry;
            this.maxDepth = i;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.pieces = list;
            this.random = randomSource;
        }

        void tryPlacingChildren(PoolElementStructurePiece poolElementStructurePiece, MutableObject<VoxelShape> sizeLimit, int i, boolean bl, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
            StructurePoolElement structurePoolElement = poolElementStructurePiece.m_209918_();
            BlockPos blockPos = poolElementStructurePiece.m_72646_();
            Rotation rotation = poolElementStructurePiece.m_6830_();
            StructureTemplatePool.Projection projection = structurePoolElement.m_210539_();
            boolean bl2 = projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableObject2 = new MutableObject<VoxelShape>();
            BoundingBox boundingBox = poolElementStructurePiece.m_73547_();
            int j = boundingBox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo structureBlockInfo : structurePoolElement.m_213638_(this.structureTemplateManager, blockPos, rotation, this.random)) {
                StructurePoolElement structurePoolElement2;
                MutableObject<VoxelShape> mutableObject3;
                Direction direction = JigsawBlock.m_54250_((BlockState)structureBlockInfo.f_74676_());
                BlockPos blockPos2 = structureBlockInfo.f_74675_();
                BlockPos blockPos3 = blockPos2.m_121945_(direction);
                int k = blockPos2.m_123342_() - j;
                int l = -1;
                ResourceKey<StructureTemplatePool> resourceKey = Placer.readPoolName(structureBlockInfo);
                Optional optional = this.pools.m_203636_(resourceKey);
                if (optional.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourceKey.m_135782_());
                    continue;
                }
                Holder holder = (Holder)optional.get();
                if (((StructureTemplatePool)holder.m_203334_()).m_210590_() == 0 && !holder.m_203565_(Pools.f_127186_)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourceKey.m_135782_());
                    continue;
                }
                Holder holder2 = ((StructureTemplatePool)holder.m_203334_()).m_254935_();
                if (((StructureTemplatePool)holder2.m_203334_()).m_210590_() == 0 && !holder2.m_203565_(Pools.f_127186_)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)holder2.m_203543_().map(resourceKeyx -> resourceKeyx.m_135782_().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean bl3 = boundingBox.m_71051_((Vec3i)blockPos3);
                if (bl3) {
                    mutableObject3 = mutableObject2;
                    if (mutableObject2.getValue() == null) {
                        mutableObject2.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingBox)));
                    }
                } else {
                    mutableObject3 = sizeLimit;
                }
                ArrayList list = Lists.newArrayList();
                if (i != this.maxDepth) {
                    list.addAll(((StructureTemplatePool)holder.m_203334_()).m_227362_(this.random));
                }
                list.addAll(((StructureTemplatePool)holder2.m_203334_()).m_227362_(this.random));
                Iterator var29 = list.iterator();
                while (var29.hasNext() && (structurePoolElement2 = (StructurePoolElement)var29.next()) != EmptyPoolElement.f_210175_) {
                    for (Rotation rotation2 : Rotation.m_221992_((RandomSource)this.random)) {
                        List list2 = structurePoolElement2.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, rotation2, this.random);
                        BoundingBox boundingBox2 = structurePoolElement2.m_214015_(this.structureTemplateManager, BlockPos.f_121853_, rotation2);
                        int m = bl && boundingBox2.m_71057_() <= 16 ? list2.stream().mapToInt(structureBlockInfox -> {
                            if (!boundingBox2.m_71051_((Vec3i)structureBlockInfox.f_74675_().m_121945_(JigsawBlock.m_54250_((BlockState)structureBlockInfox.f_74676_())))) {
                                return 0;
                            }
                            ResourceKey<StructureTemplatePool> templatePoolResourceKey = Placer.readPoolName(structureBlockInfox);
                            Optional optionalJ1 = this.pools.m_203636_(templatePoolResourceKey);
                            Optional<Holder> optional2 = optionalJ1.map(holderJ3 -> ((StructureTemplatePool)holderJ3.m_203334_()).m_254935_());
                            int p = optionalJ1.map(holderJ1 -> ((StructureTemplatePool)holderJ1.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                            int h = optional2.map(holderJ2 -> ((StructureTemplatePool)holderJ2.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                            return Math.max(p, h);
                        }).max().orElse(0) : 0;
                        for (StructureTemplate.StructureBlockInfo structureBlockInfo2 : list2) {
                            int u;
                            int s;
                            int q;
                            if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)structureBlockInfo, (StructureTemplate.StructureBlockInfo)structureBlockInfo2)) continue;
                            BlockPos blockPos4 = structureBlockInfo2.f_74675_();
                            BlockPos blockPos5 = blockPos3.m_121996_((Vec3i)blockPos4);
                            BoundingBox boundingBox3 = structurePoolElement2.m_214015_(this.structureTemplateManager, blockPos5, rotation2);
                            int n = boundingBox3.m_162396_();
                            StructureTemplatePool.Projection projection2 = structurePoolElement2.m_210539_();
                            boolean bl4 = projection2 == StructureTemplatePool.Projection.RIGID;
                            int o = blockPos4.m_123342_();
                            int p = k - o + JigsawBlock.m_54250_((BlockState)structureBlockInfo.f_74676_()).m_122430_();
                            if (bl2 && bl4) {
                                q = j + p;
                            } else {
                                if (l == -1) {
                                    l = this.chunkGenerator.m_223221_(blockPos2.m_123341_(), blockPos2.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState);
                                }
                                q = l - o;
                            }
                            int r = q - n;
                            BoundingBox boundingBox4 = boundingBox3.m_71045_(0, r, 0);
                            BlockPos blockPos6 = blockPos5.m_7918_(0, r, 0);
                            if (m > 0) {
                                s = Math.max(m + 1, boundingBox4.m_162400_() - boundingBox4.m_162396_());
                                boundingBox4.m_162371_(new BlockPos(boundingBox4.m_162395_(), boundingBox4.m_162396_() + s, boundingBox4.m_162398_()));
                            }
                            if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableObject3.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingBox4)), (BooleanOp)BooleanOp.f_82683_)) continue;
                            mutableObject3.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableObject3.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingBox4)), (BooleanOp)BooleanOp.f_82685_));
                            s = poolElementStructurePiece.m_72647_();
                            int t = bl4 ? s - p : structurePoolElement2.m_210540_();
                            PoolElementStructurePiece poolElementStructurePiece2 = new PoolElementStructurePiece(this.structureTemplateManager, structurePoolElement2, blockPos6, t, rotation2, boundingBox4);
                            if (bl2) {
                                u = j + k;
                            } else if (bl4) {
                                u = q + o;
                            } else {
                                if (l == -1) {
                                    l = this.chunkGenerator.m_223221_(blockPos2.m_123341_(), blockPos2.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, randomState);
                                }
                                u = l + p / 2;
                            }
                            poolElementStructurePiece.m_209916_(new JigsawJunction(blockPos3.m_123341_(), u - k + s, blockPos3.m_123343_(), p, projection2));
                            poolElementStructurePiece2.m_209916_(new JigsawJunction(blockPos2.m_123341_(), u - o + t, blockPos2.m_123343_(), -p, projection));
                            this.pieces.add((PoolElementStructurePiece)poolElementStructurePiece2);
                            if (i + 1 > this.maxDepth) continue block0;
                            this.placing.addLast(new PieceState(poolElementStructurePiece2, mutableObject3, i + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolName(StructureTemplate.StructureBlockInfo structureBlockInfo) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation(structureBlockInfo.f_74677_().m_128461_("pool")));
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece poolElementStructurePiece, MutableObject<VoxelShape> mutableObject, int i) {
            this.piece = poolElementStructurePiece;
            this.free = mutableObject;
            this.depth = i;
        }
    }
}

