/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.Objects;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.GrenadeEffectCloud;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class ThrownAntidote
extends ThrowableItemProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<Boolean> IS_STUCK = SynchedEntityData.m_135353_(ThrownAntidote.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICK_COUNTER = SynchedEntityData.m_135353_(ThrownAntidote.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ThrownAntidote(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownAntidote(Level level, LivingEntity livingEntity) {
        super((EntityType)JNEEntityType.ANTIDOTE.get(), livingEntity, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getIsStuck()) {
            int tick = this.getTickCounter();
            this.setTickCounter(tick + 1);
            ItemStack stack = this.m_7846_();
            MobEffect mobEffect = ThrownAntidote.getAntidoteEffect(stack);
            if (tick % 10 == 0) {
                if (this.m_9236_().f_46443_) {
                    if (mobEffect != null) {
                        this.playPotionParticles(mobEffect);
                    } else {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123772_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, (double)0.2f, 0.0);
                    }
                }
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.GRENADE_ANTIDOTE_TICK.get(), SoundSource.NEUTRAL, 1.0f, 0.75f + (float)tick / 20.0f);
            } else if (tick > 40) {
                assert (stack.m_41783_() != null);
                if (stack.m_41783_().m_128441_("Antidote")) {
                    this.applyGrenade(stack);
                }
                this.m_146870_();
                if (mobEffect != null) {
                    this.playPotionParticles(mobEffect);
                } else {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123772_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, (double)0.2f, 0.0);
                }
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.GRENADE_ANTIDOTE_EXPLODE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().f_46443_) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_20242_(true);
            this.m_20088_().m_135381_(IS_STUCK, (Object)true);
        }
    }

    private void applyGrenade(ItemStack stack) {
        GrenadeEffectCloud grenadeEffectCloud = new GrenadeEffectCloud(this.m_9236_(), this.m_20185_() - 2.0, this.m_20186_(), this.m_20189_());
        Entity entity = this.m_19749_();
        CompoundTag nbt = stack.m_41783_();
        if (entity instanceof LivingEntity) {
            grenadeEffectCloud.setOwnerUUID((LivingEntity)entity);
        }
        grenadeEffectCloud.setMobEffect(ThrownAntidote.getAntidoteEffect(stack));
        grenadeEffectCloud.setEffectDuration(ThrownAntidote.getDuration(stack));
        if (nbt != null) {
            if (nbt.m_128441_("Inactive")) {
                grenadeEffectCloud.setInactive(nbt.m_128471_("Inactive"));
            } else {
                grenadeEffectCloud.setInactive(false);
            }
            if (nbt.m_128425_("CustomAntidoteColor", 99)) {
                grenadeEffectCloud.setColor(nbt.m_128451_("CustomPotionColor"));
            } else {
                grenadeEffectCloud.setColor(Objects.requireNonNull(ThrownAntidote.getAntidoteEffect(stack)).m_19484_());
            }
        }
        this.m_9236_().m_7967_((Entity)grenadeEffectCloud);
    }

    private void playPotionParticles(MobEffect mobEffect) {
        int c = mobEffect.m_19484_();
        if (c > 0) {
            double d0 = (double)(c >> 16 & 0xFF) / 255.0;
            double d1 = (double)(c >> 8 & 0xFF) / 255.0;
            double d2 = (double)(c & 0xFF) / 255.0;
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)JNEParticleTypes.IMMUNITY_EFFECT.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_STUCK, (Object)false);
        this.m_20088_().m_135372_(TICK_COUNTER, (Object)0);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("isStuck")) {
            this.setIsStuck(nbt.m_128471_("isStuck"));
        }
        if (nbt.m_128441_("TickCounter")) {
            this.setTickCounter(nbt.m_128451_("TickCounter"));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("isStuck", this.getIsStuck());
        nbt.m_128405_("TickCounter", this.getTickCounter());
    }

    private int getTickCounter() {
        return (Integer)this.m_20088_().m_135370_(TICK_COUNTER);
    }

    private void setTickCounter(int i) {
        this.m_20088_().m_135381_(TICK_COUNTER, (Object)i);
    }

    private boolean getIsStuck() {
        return (Boolean)this.m_20088_().m_135370_(IS_STUCK);
    }

    private void setIsStuck(boolean bl) {
        this.m_20088_().m_135381_(IS_STUCK, (Object)bl);
    }

    private static MobEffect getAntidoteEffect(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("AntidoteEffect") || Objects.equals(nbt.m_128461_("Antidote"), "Awkward")) {
            return null;
        }
        ResourceLocation antidoteLocation = new ResourceLocation(stack.m_41784_().m_128461_("AntidoteEffect"));
        return Objects.requireNonNull((MobEffect)BuiltInRegistries.f_256974_.m_7745_(antidoteLocation));
    }

    public static int getDuration(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("Duration")) {
            return nbt.m_128451_("Duration") * 20;
        }
        return 36000;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)JNEItems.GRENADE_ANTIDOTE.get();
    }

    protected float m_7139_() {
        return 0.05f;
    }
}

