/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class GrenadeEffectCloud
extends Entity
implements TraceableEntity {
    private final int duration;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private MobEffect effect;
    private int effectDuration;
    private boolean inactive;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(GrenadeEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> WATER_SENSITIVE_OR_ON_FIRE = arg -> arg.m_6126_() || arg.m_6060_();

    public GrenadeEffectCloud(EntityType<?> type, Level level) {
        super(type, level);
        this.duration = 100;
        this.f_19794_ = true;
    }

    public GrenadeEffectCloud(Level level, double d, double e, double f) {
        super((EntityType)JNEEntityType.GRENADE_EFFECT_CLOUD.get(), level);
        this.duration = 100;
        this.f_19794_ = true;
        this.m_6034_(d, e, f);
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double e = this.m_20186_();
        double f = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, e, f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            int c = (Integer)this.f_19804_.m_135370_(COLOR);
            if (c > 0) {
                if (this.f_19796_.m_188503_(5) == 0) {
                    double d0 = (double)(c >> 16 & 0xFF) / 255.0;
                    double d1 = (double)(c >> 8 & 0xFF) / 255.0;
                    double d2 = (double)(c & 0xFF) / 255.0;
                    for (int i = 0; i < 20; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)JNEParticleTypes.IMMUNITY_EFFECT.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                    }
                }
            } else if (this.f_19796_.m_188503_(5) == 0) {
                for (int i = 0; i < 20; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123772_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, (double)0.2f, 0.0);
                }
            }
        } else if (this.f_19797_ >= this.duration) {
            this.m_146870_();
        } else if (this.effect != null && !this.inactive) {
            this.effectLivingEntities(this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.f_20403_));
        } else {
            this.applyWater();
        }
    }

    private void effectLivingEntities(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.effect == null) continue;
            livingEntity.m_147207_(new MobEffectInstance(this.effect, this.effectDuration, 0, false, true), (Entity)this);
        }
    }

    private void applyWater() {
        AABB aABB = this.m_20191_();
        List list = this.m_9236_().m_6443_(LivingEntity.class, aABB, WATER_SENSITIVE_OR_ON_FIRE);
        for (LivingEntity livingEntity : list) {
            double d = this.m_20280_((Entity)livingEntity);
            if (!(d < 16.0)) continue;
            if (livingEntity.m_6126_()) {
                livingEntity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.getOwner()), 15.0f);
            }
            if (!livingEntity.m_6060_() || !livingEntity.m_6084_()) continue;
            livingEntity.m_252836_();
        }
        List list2 = this.m_9236_().m_45976_(Axolotl.class, aABB);
        for (Axolotl axolotl : list2) {
            axolotl.m_149177_();
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(COLOR, (Object)0);
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("Owner")) {
            this.ownerUUID = nbt.m_128342_("Owner");
        }
        if (nbt.m_128441_("Color")) {
            this.setColor(nbt.m_128451_("Color"));
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        if (this.ownerUUID != null) {
            nbt.m_128362_("Owner", this.ownerUUID);
        }
        nbt.m_128405_("Color", this.getColor());
    }

    public void setMobEffect(MobEffect effect) {
        this.effect = effect;
    }

    public void setEffectDuration(int effectDuration) {
        this.effectDuration = effectDuration;
    }

    public void setColor(int i) {
        this.m_20088_().m_135381_(COLOR, (Object)i);
    }

    public void setInactive(boolean bl) {
        this.inactive = bl;
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setOwnerUUID(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }
}

