/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import net.jadenxgamer.netherexp.registry.block.custom.SpottedWartBlock;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class DecayableWartBlock
extends Block {
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)10);
    public static final IntegerProperty SPOTS = IntegerProperty.m_61631_((String)"spots", (int)0, (int)3);
    protected final Block persistent;
    protected final int type;

    public DecayableWartBlock(BlockBehaviour.Properties properties, int type, Block persistent) {
        super(properties);
        this.type = type;
        this.persistent = persistent;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(10))).m_61124_((Property)SPOTS, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 10;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.shouldDecay(state)) {
            level.m_7471_(pos, false);
        }
    }

    protected boolean shouldDecay(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 10;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, DecayableWartBlock.updateDistanceFromStem(state, (LevelAccessor)level, pos), 3);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        int i = DecayableWartBlock.getDistanceFromStem(neighborState) + 1;
        if (i != 1 || (Integer)state.m_61143_((Property)DISTANCE) != i) {
            levelAccessor.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    private static void dropLight(Level level, BlockPos pos, BlockState state, Direction direction) {
        int s = (Integer)state.m_61143_((Property)SPOTS);
        SpottedWartBlock.m_152435_((Level)level, (BlockPos)pos, (Direction)direction, (ItemStack)new ItemStack((ItemLike)JNEItems.LIGHTSPORES.get(), s));
    }

    private static void dropNight(Level level, BlockPos pos, BlockState state, Direction direction) {
        int s = (Integer)state.m_61143_((Property)SPOTS);
        SpottedWartBlock.m_152435_((Level)level, (BlockPos)pos, (Direction)direction, (ItemStack)new ItemStack((ItemLike)JNEItems.NIGHTSPORES.get(), s));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        boolean bl = false;
        int s = (Integer)state.m_61143_((Property)SPOTS);
        if (itemStack.m_150930_(Items.f_42574_) && s >= 1) {
            switch (this.type) {
                default: {
                    DecayableWartBlock.dropLight(level, pos, state, hitResult.m_82434_());
                    break;
                }
                case 2: {
                    DecayableWartBlock.dropNight(level, pos, state, hitResult.m_82434_());
                }
            }
            level.m_5594_(player, pos, (SoundEvent)JNESoundEvents.LIGHTSPORES_SHEAR.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SPOTS, (Comparable)Integer.valueOf(0)));
            level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
            itemStack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
            bl = true;
        }
        if (!level.f_46443_ && bl) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        }
        if (bl) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean maxSpots(BlockState state) {
        return (Integer)state.m_61143_((Property)SPOTS) == 3;
    }

    public BlockState setSpots(BlockState state) {
        int s = (Integer)state.m_61143_((Property)SPOTS);
        return (BlockState)state.m_61124_((Property)SPOTS, (Comparable)Integer.valueOf(s + 1));
    }

    private static BlockState updateDistanceFromStem(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
        Direction[] var5;
        int i = 10;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : var5 = Direction.values()) {
            mutableBlockPos.m_122159_((Vec3i)blockPos, direction);
            i = Math.min(i, DecayableWartBlock.getDistanceFromStem(levelAccessor.m_8055_((BlockPos)mutableBlockPos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)blockState.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceFromStem(BlockState state) {
        if (state.m_204336_(JNETags.Blocks.STEMS)) {
            return 0;
        }
        if (state.m_60734_() instanceof DecayableWartBlock) {
            return (Integer)state.m_61143_((Property)DISTANCE);
        }
        return 10;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int d = (Integer)state.m_61143_((Property)DISTANCE);
        float f = random.m_188501_();
        double x = (double)pos.m_123341_() + random.m_188500_();
        double y = (double)pos.m_123342_() - 0.05;
        double z = (double)pos.m_123343_() + random.m_188500_();
        if (d >= 10 && f < 0.3f) {
            switch (this.type) {
                default: {
                    level.m_7106_((ParticleOptions)JNEParticleTypes.FALLING_NETHER_WART.get(), x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    level.m_7106_((ParticleOptions)JNEParticleTypes.FALLING_WARPED_WART.get(), x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, SPOTS});
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.persistent);
    }
}

