/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;

public class GuiLabelEx {
    protected int width;
    protected int height;
    public int x;
    public int y;
    private final List<FormattedCharSequence> labels;
    public int id;
    private boolean centered;
    public boolean visible = true;
    private final int textColor;
    private final Font fontRenderer;

    public GuiLabelEx(Font fontRendererObj, int id, int x, int y, int width, int height, int textColor) {
        this.fontRenderer = fontRendererObj;
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.labels = Lists.newArrayList();
        this.centered = false;
        this.textColor = textColor;
    }

    public void addLine(FormattedCharSequence line) {
        this.labels.add(line);
    }

    public GuiLabelEx setCentered() {
        this.centered = true;
        return this;
    }

    public void drawLabel(GuiGraphics guiGraphics, Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            for (int row = 0; row < this.labels.size(); ++row) {
                int posY;
                int posX;
                if (this.centered) {
                    posX = this.x + this.width / 2;
                    posY = this.y + row * 10;
                    guiGraphics.m_280648_(this.fontRenderer, this.labels.get(row), posX - this.fontRenderer.m_92724_(this.labels.get(row)) / 2, posY, this.textColor);
                    continue;
                }
                posX = this.x;
                posY = this.y + row * 10;
                guiGraphics.m_280648_(this.fontRenderer, this.labels.get(row), posX, posY, this.textColor);
            }
        }
    }
}

