/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.network;

import com.ibarnstormer.gbd.event.ClientModEvents;
import com.ibarnstormer.gbd.network.IModPacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class BroadcastBeamReactorSoundPacket
implements IModPacket {
    int playerID;
    int beamID;

    public BroadcastBeamReactorSoundPacket(int playerID, int beamID) {
        this.playerID = playerID;
        this.beamID = beamID;
    }

    public BroadcastBeamReactorSoundPacket(FriendlyByteBuf buf) {
        this.playerID = buf.readInt();
        this.beamID = buf.readInt();
    }

    @Override
    public void send(FriendlyByteBuf buf) {
        buf.writeInt(this.playerID);
        buf.writeInt(this.beamID);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                Entity sourcePlayer = Minecraft.m_91087_().f_91073_.m_6815_(this.playerID);
                Entity beam = Minecraft.m_91087_().f_91073_.m_6815_(this.beamID);
                if (Minecraft.m_91087_().f_91074_ != null) {
                    ClientModEvents.ClientForgeEvents.handleBeamReactorSound(sourcePlayer, beam);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

