/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.entities;

import com.ibarnstormer.gbd.registry.ModDamageSources;
import com.ibarnstormer.gbd.registry.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class TurretBeamLaserEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> DATA_TICK = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> CHARGE_SPEED = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_CACHED_TARGET_ID = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_RANGE = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAGIC_DAMAGE = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOB_DAMAGE = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IGNORE_INVUL_FRAMES = SynchedEntityData.m_135353_(TurretBeamLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private UUID targetUUID;
    @Nullable
    private Entity cachedTarget;
    @Nullable
    private BlockEntity cachedSource;
    private int clientSideAttackTime;
    private int beamTick;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected int lerpSteps;

    public TurretBeamLaserEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public TurretBeamLaserEntity(Level level, LivingEntity target, BlockEntity source, float chargeSpeed, int maxRange, int magicDamage, int mobDamage, boolean ignoreInvulFrames) {
        super((EntityType)ModEntities.TURRET_BEAM_LASER_ENTITY.get(), level);
        this.f_19804_.m_135381_(DATA_CACHED_TARGET_ID, (Object)target.m_19879_());
        this.f_19804_.m_135381_(CHARGE_SPEED, (Object)Float.valueOf(chargeSpeed));
        this.f_19804_.m_135381_(MAX_RANGE, (Object)maxRange);
        this.f_19804_.m_135381_(MAGIC_DAMAGE, (Object)magicDamage);
        this.f_19804_.m_135381_(MOB_DAMAGE, (Object)mobDamage);
        this.f_19804_.m_135381_(IGNORE_INVUL_FRAMES, (Object)ignoreInvulFrames);
        this.cachedTarget = target;
        this.cachedSource = source;
        this.targetUUID = target.m_20148_();
        this.beamTick = 0;
    }

    public void m_8119_() {
        Entity target;
        super.m_8119_();
        this.f_19811_ = true;
        if ((float)((Integer)this.f_19804_.m_135370_(DATA_TICK)).intValue() < this.getChargeSpeed() + 5.0f) {
            this.f_19804_.m_135381_(DATA_TICK, (Object)((Integer)this.f_19804_.m_135370_(DATA_TICK) + 1));
        }
        ++this.beamTick;
        if (this.m_9236_().f_46443_ && (float)this.clientSideAttackTime < this.getChargeSpeed() + 1.0f) {
            ++this.clientSideAttackTime;
        }
        if (!this.m_213877_()) {
            this.lerpPosition();
        }
        if ((target = this.getTarget()) != null) {
            if (target.m_9236_() == this.m_9236_() && target.m_9236_().m_46472_() == this.m_9236_().m_46472_()) {
                Vec3 vec3 = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_());
                Vec3 vec31 = this.m_20182_();
                Vec3 vec32 = vec31.m_82546_(vec3);
                Vec3 vec33 = vec31.m_82546_(vec32.m_82541_().m_82490_(1.125));
                BlockHitResult cast = this.m_9236_().m_45547_(new ClipContext(vec33, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (cast.m_6662_() == HitResult.Type.BLOCK) {
                    this.m_146870_();
                }
                double range = ((Integer)this.f_19804_.m_135370_(MAX_RANGE)).intValue();
                if (this.m_20280_(target) > Math.pow(range, 3.0)) {
                    this.m_146870_();
                }
                if ((float)this.getTick() >= this.getChargeSpeed() + 1.0f) {
                    target.m_6469_(target.m_269291_().m_269425_(), (float)((Integer)this.f_19804_.m_135370_(MAGIC_DAMAGE)).intValue());
                    target.m_6469_(ModDamageSources.of("turret_beam_physical", null, this.m_9236_()), (float)((Integer)this.f_19804_.m_135370_(MOB_DAMAGE)).intValue());
                    if (((Boolean)this.f_19804_.m_135370_(IGNORE_INVUL_FRAMES)).booleanValue()) {
                        target.f_19802_ = 0;
                        if (target instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)target;
                            this.applyKnockback(livingEntity);
                        }
                    } else if (target.f_19802_ >= 20 && target instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)target;
                        this.applyKnockback(livingEntity);
                    }
                }
            } else {
                this.m_146870_();
            }
        }
        if ((float)((Integer)this.f_19804_.m_135370_(DATA_TICK)).intValue() >= this.getChargeSpeed() + 5.0f) {
            this.cachedTarget = null;
            this.targetUUID = null;
            this.m_146870_();
        }
    }

    private void applyKnockback(LivingEntity entity) {
        double d0 = this.m_20185_() - entity.m_20185_();
        double d1 = this.m_20189_() - entity.m_20189_();
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        entity.m_147240_((double)0.4f, d0, d1);
    }

    @Nullable
    public Entity getCachedTarget() {
        if (this.m_9236_().f_46443_) {
            Entity target = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_CACHED_TARGET_ID)).intValue());
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                return livingTarget;
            }
            return null;
        }
        return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_CACHED_TARGET_ID)).intValue());
    }

    @Nullable
    public Entity getTarget() {
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedTarget = ((ServerLevel)this.m_9236_()).m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TICK, (Object)0);
        this.f_19804_.m_135372_(CHARGE_SPEED, (Object)Float.valueOf(120.0f));
        this.f_19804_.m_135372_(DATA_CACHED_TARGET_ID, (Object)0);
        this.f_19804_.m_135372_(MAX_RANGE, (Object)17);
        this.f_19804_.m_135372_(MAGIC_DAMAGE, (Object)3);
        this.f_19804_.m_135372_(MOB_DAMAGE, (Object)6);
        this.f_19804_.m_135372_(IGNORE_INVUL_FRAMES, (Object)false);
    }

    public float getAttackAnimationScale(float p_32813_) {
        return ((float)this.clientSideAttackTime + p_32813_) / this.getChargeSpeed();
    }

    public int getClientSideAttackTime() {
        return this.clientSideAttackTime;
    }

    public float getChargeSpeed() {
        return ((Float)this.f_19804_.m_135370_(CHARGE_SPEED)).floatValue();
    }

    public int getTick() {
        return (Integer)this.f_19804_.m_135370_(DATA_TICK);
    }

    public int getBeamTick() {
        return this.beamTick;
    }

    public void m_6453_(double p_20977_, double p_20978_, double p_20979_, float p_20980_, float p_20981_, int p_20982_, boolean p_20983_) {
        this.lerpX = p_20977_;
        this.lerpY = p_20978_;
        this.lerpZ = p_20979_;
        this.lerpSteps = p_20982_;
    }

    public void lerpPosition() {
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d2 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d4 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    protected void m_7378_(CompoundTag p_20052_) {
        if (p_20052_.m_128403_("Target")) {
            this.targetUUID = p_20052_.m_128342_("Target");
        }
    }

    protected void m_7380_(@NotNull CompoundTag p_20139_) {
        if (this.targetUUID != null) {
            p_20139_.m_128362_("Target", this.targetUUID);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource p_37616_, float p_37617_) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

