/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.export;

import com.mojang.blaze3d.platform.NativeImage;
import forge.com.hollingsworth.schematic.export.GuidebookLevelRenderer;
import forge.com.hollingsworth.schematic.export.LytSize;
import forge.com.hollingsworth.schematic.export.OffScreenRenderer;
import forge.com.hollingsworth.schematic.export.SavedCameraSettings;
import forge.com.hollingsworth.schematic.export.Scene;
import forge.com.hollingsworth.schematic.export.level.FakeForwardingServerLevel;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class WrappedScene {
    @Nullable
    public Scene scene;
    public final Viewport viewport = new Viewport();
    private SavedCameraSettings initialCameraSettings = new SavedCameraSettings();

    public void setScene(@Nullable Scene scene) {
        this.scene = scene;
        this.initialCameraSettings = scene != null ? scene.getCameraSettings().save() : new SavedCameraSettings();
    }

    public void placeStructure(Path filePath) {
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(filePath, StandardOpenOption.READ))));){
            CompoundTag compoundTag = NbtIo.m_128934_((DataInput)stream, (NbtAccounter)new NbtAccounter(0x20000000L));
            StructureTemplate template = new StructureTemplate();
            HolderLookup.RegistryLookup blocks = this.scene.getLevel().m_9598_().m_175515_(Registries.f_256747_).m_255303_();
            template.m_246595_((HolderGetter)blocks, compoundTag);
            this.placeStructure(template);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void placeStructure(StructureTemplate structureTemplate) {
        SingleThreadedRandomSource random = new SingleThreadedRandomSource(0L);
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.m_74392_(true);
        structureTemplate.m_230328_((ServerLevelAccessor)new FakeForwardingServerLevel((LevelAccessor)this.scene.getLevel()), BlockPos.f_121853_, BlockPos.f_121853_, settings, (RandomSource)random, 0);
    }

    public ImageExport exportAsPng(float scale) {
        if (this.scene == null) {
            return null;
        }
        LytSize prefSize = this.viewport.getPreferredSize();
        LytSize scaledSize = this.getSizeForExport(scale);
        if (scaledSize == null) {
            return null;
        }
        return this.exportAsPng(scaledSize.width(), scaledSize.height(), prefSize);
    }

    public ImageExport exportPreviewPng() {
        if (this.scene == null) {
            return null;
        }
        LytSize rescaledSize = this.getSizeForPreview();
        if (rescaledSize == null) {
            return null;
        }
        return this.exportAsPng(rescaledSize.width(), rescaledSize.height(), this.viewport.getPreferredSize());
    }

    public ImageExport exportAsPng(int width, int height, LytSize viewportSize) {
        try (OffScreenRenderer osr = new OffScreenRenderer(width, height);){
            byte[] image = osr.captureAsPng(() -> {
                GuidebookLevelRenderer renderer = GuidebookLevelRenderer.getInstance();
                this.scene.getCameraSettings().setViewportSize(viewportSize);
                renderer.render(this.scene.getLevel(), this.scene.getCameraSettings());
            });
            ImageExport imageExport = new ImageExport(new LytSize(width, height), image);
            return imageExport;
        }
    }

    @Nullable
    public LytSize getSizeForExport(float scale) {
        LytSize prefSize = this.viewport.getPreferredSize();
        if (prefSize.width() <= 0 || prefSize.height() <= 0) {
            return null;
        }
        int width = (int)Math.max(1.0f, (float)prefSize.width() * scale);
        int height = (int)Math.max(1.0f, (float)prefSize.height() * scale);
        return new LytSize(width, height);
    }

    @Nullable
    public LytSize getSizeForPreview() {
        LytSize prefSize = this.viewport.getPreferredSize();
        if (prefSize.width() <= 0 || prefSize.height() <= 0) {
            return null;
        }
        int maxWidth = 400;
        int originalWidth = prefSize.width();
        int originalHeight = prefSize.height();
        double scaleFactor = (double)maxWidth / (double)originalWidth;
        int newHeight = (int)((double)originalHeight * scaleFactor);
        int newWidth = (int)((double)originalWidth * scaleFactor);
        return new LytSize(newWidth, newHeight);
    }

    public void renderToCurrentTarget(LytSize size) {
        if (this.scene == null) {
            return;
        }
        GuidebookLevelRenderer renderer = GuidebookLevelRenderer.getInstance();
        this.scene.getCameraSettings().setViewportSize(size);
        renderer.render(this.scene.getLevel(), this.scene.getCameraSettings());
    }

    public LytSize getPreferredSize() {
        if (this.scene == null) {
            return LytSize.empty();
        }
        return this.viewport.getPreferredSize();
    }

    public NativeImage asNativeImage(float scale) {
        return null;
    }

    class Viewport {
        Viewport() {
        }

        public LytSize getPreferredSize() {
            if (WrappedScene.this.scene == null) {
                return LytSize.empty();
            }
            SavedCameraSettings current = WrappedScene.this.scene.getCameraSettings().save();
            WrappedScene.this.scene.getCameraSettings().restore(WrappedScene.this.initialCameraSettings);
            Vector4f screenBounds = WrappedScene.this.scene.getScreenBounds();
            WrappedScene.this.scene.getCameraSettings().restore(current);
            int width = (int)Math.ceil(Math.abs(screenBounds.z - screenBounds.x));
            int height = (int)Math.ceil(Math.abs(screenBounds.w - screenBounds.y));
            return new LytSize(width, height);
        }
    }

    public record ImageExport(LytSize size, byte[] image) {
    }
}

