/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.export;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import forge.com.hollingsworth.schematic.client.renderer.StatePos;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Template {
    public String name;
    public String statePosArrayList;
    public Map<String, Integer> requiredItems = new Object2IntOpenHashMap();
    private static final ImmutableList<Property<?>> DENY_PROPERTIES = ImmutableList.of((Object)BlockStateProperties.f_61405_, (Object)BlockStateProperties.f_61406_, (Object)BlockStateProperties.f_61407_, (Object)BlockStateProperties.f_222999_, (Object)BlockStateProperties.f_61408_, (Object)BlockStateProperties.f_61409_, (Object)BlockStateProperties.f_61410_, (Object)BlockStateProperties.f_61411_, (Object)DoublePlantBlock.f_52858_, (Object)BlockStateProperties.f_61362_, (Object)BlockStateProperties.f_61443_, (Object)BlockStateProperties.f_61439_, (Object[])new Property[]{BlockStateProperties.f_61440_, BlockStateProperties.f_61446_, BlockStateProperties.f_61387_});

    public Template(String name, BlockPos start, BlockPos end) {
        this.name = name;
        ArrayList<StatePos> statePosArrayList = Template.listForDire(start, end, (Level)Minecraft.m_91087_().f_91073_);
        this.statePosArrayList = Template.statePosListToNBTMapArray(statePosArrayList).toString();
        Map<ItemStackKey, Integer> requiredItemsTemp = StatePos.getItemList(statePosArrayList);
        for (Map.Entry<ItemStackKey, Integer> entry : requiredItemsTemp.entrySet()) {
            if (entry.getKey().getStack().m_41619_()) continue;
            Item item = entry.getKey().item;
            ResourceLocation registryName = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            this.requiredItems.put(registryName.toString(), entry.getValue());
        }
    }

    public String toJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    public static ArrayList<StatePos> listForDire(BlockPos startRaw, BlockPos endRaw, Level level) {
        ArrayList<StatePos> list = new ArrayList<StatePos>();
        AABB area = new AABB(startRaw, endRaw);
        BlockPos.m_121921_((AABB)area).map(BlockPos::m_7949_).forEach(pos -> {
            if (Template.validStateForDire(level.m_8055_(pos), level, pos)) {
                list.add(new StatePos(Template.cleanBlockState(level.m_8055_(pos)), pos.m_121996_((Vec3i)startRaw)));
            } else {
                list.add(new StatePos(Blocks.f_50016_.m_49966_(), pos.m_121996_((Vec3i)startRaw)));
            }
        });
        return list;
    }

    public static CompoundTag statePosListToNBTMapArray(ArrayList<StatePos> list) {
        CompoundTag tag = new CompoundTag();
        ArrayList<BlockState> blockStateMap = StatePos.getBlockStateMap(list);
        ListTag blockStateMapList = StatePos.getBlockStateNBT(blockStateMap);
        int[] blocklist = new int[list.size()];
        int[] counter = new int[]{0};
        BlockPos start = list.get((int)0).pos;
        BlockPos end = list.get((int)(list.size() - 1)).pos;
        AABB aabb = new AABB(start, end);
        Map<BlockPos, BlockState> blockStateByPos = list.stream().collect(Collectors.toMap(e -> e.pos, e -> e.state));
        BlockPos.m_121921_((AABB)aabb).map(BlockPos::m_7949_).forEach(pos -> {
            BlockState blockState = (BlockState)blockStateByPos.get(pos);
            int n = counter[0];
            counter[0] = n + 1;
            blocklist[n] = blockStateMap.indexOf(blockState);
        });
        tag.m_128365_("startpos", (Tag)NbtUtils.m_129224_((BlockPos)start));
        tag.m_128365_("endpos", (Tag)NbtUtils.m_129224_((BlockPos)end));
        tag.m_128365_("blockstatemap", (Tag)blockStateMapList);
        tag.m_128385_("statelist", blocklist);
        return tag;
    }

    public static BlockState cleanBlockState(BlockState sourceState) {
        BlockState placeState = sourceState.m_60734_().m_49966_();
        for (Property prop : sourceState.m_61147_()) {
            if (DENY_PROPERTIES.contains((Object)prop)) continue;
            placeState = Template.applyProperty(placeState, sourceState, prop);
        }
        return placeState;
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, BlockState from, Property<T> prop) {
        return (BlockState)state.m_61124_(prop, from.m_61143_(prop));
    }

    public static boolean validStateForDire(BlockState blockState, Level level, BlockPos blockPos) {
        if (blockState.m_60800_((BlockGetter)level, blockPos) < 0.0f) {
            return false;
        }
        return blockState.m_60819_().m_76178_() || blockState.m_60819_().m_76170_();
    }

    public static ArrayList<StatePos> statePosListFromNBTMapArray(CompoundTag tag) {
        ArrayList<StatePos> statePosList = new ArrayList<StatePos>();
        if (!tag.m_128441_("blockstatemap") || !tag.m_128441_("statelist")) {
            return statePosList;
        }
        ArrayList<BlockState> blockStateMap = StatePos.getBlockStateMapFromNBT(tag.m_128437_("blockstatemap", 10));
        BlockPos start = Template.readBlockPos(tag, "startpos");
        BlockPos end = Template.readBlockPos(tag, "endpos");
        AABB aabb = Template.aabbFromBlockPos(start, end);
        int[] blocklist = tag.m_128465_("statelist");
        int[] counter = new int[]{0};
        BlockPos.m_121921_((AABB)aabb).map(BlockPos::m_7949_).forEach(pos -> {
            int n = counter[0];
            counter[0] = n + 1;
            int blockStateLookup = blocklist[n];
            BlockState blockState = (BlockState)blockStateMap.get(blockStateLookup);
            statePosList.add(new StatePos(blockState, (BlockPos)pos));
        });
        return statePosList;
    }

    public static BlockPos readBlockPos(CompoundTag compoundTag, String pKey) {
        if (!compoundTag.m_128441_(pKey)) {
            return BlockPos.f_121853_;
        }
        CompoundTag tag = compoundTag.m_128469_(pKey);
        return new BlockPos(tag.m_128451_("X"), tag.m_128451_("Y"), tag.m_128451_("Z"));
    }

    public static Vec3 blockPosToVec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static AABB aabbFromBlockPos(BlockPos start, BlockPos end) {
        return new AABB(Template.blockPosToVec3(start), Template.blockPosToVec3(end));
    }

    public static CompoundTag readCompressed(InputStream pZippedStream, NbtAccounter pAccounter) throws IOException {
        CompoundTag compoundtag;
        try (DataInputStream datainputstream = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new GZIPInputStream(pZippedStream)));){
            compoundtag = NbtIo.m_128934_((DataInput)datainputstream, (NbtAccounter)pAccounter);
        }
        return compoundtag;
    }

    public static class ItemStackKey {
        public final Item item;
        public final CompoundTag nbt;
        public final int hash;

        public ItemStackKey(ItemStack stack, boolean compareNBT) {
            this.item = stack.m_41720_();
            this.nbt = compareNBT ? stack.m_41783_() : new CompoundTag();
            this.hash = Objects.hash(this.item, this.nbt);
        }

        public ItemStack getStack() {
            ItemStack stack = new ItemStack((ItemLike)this.item, 1);
            if (this.nbt != null && !this.nbt.m_128456_()) {
                stack.m_41751_(this.nbt);
            }
            return stack;
        }

        public ItemStack getStack(int amt) {
            ItemStack stack = new ItemStack((ItemLike)this.item, amt);
            if (this.nbt != null && !this.nbt.m_128456_()) {
                stack.m_41751_(this.nbt);
            }
            return stack;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemStackKey) {
                return ((ItemStackKey)obj).item == this.item && Objects.equals(((ItemStackKey)obj).nbt, this.nbt);
            }
            return false;
        }
    }
}

