/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.common.network;

import forge.com.hollingsworth.schematic.common.network.ClientMessageHandler;
import forge.com.hollingsworth.schematic.common.network.Message;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageHandler {
    public static <T extends Message> void handle(T message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.get().enqueueWork(() -> MessageHandler.handleServer(message, ctx));
        } else {
            ctx.get().enqueueWork(() -> ClientMessageHandler.handleClient(message, ctx));
        }
        ctx.get().setPacketHandled(true);
    }

    public static <T extends Message> void handleServer(T message, Supplier<NetworkEvent.Context> ctx) {
        MinecraftServer server = ctx.get().getSender().f_19853_.m_7654_();
        message.onServerReceived(server, ctx.get().getSender(), ctx.get());
    }
}

