/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.renderer;

import forge.com.hollingsworth.schematic.client.renderer.TagPos;
import forge.com.hollingsworth.schematic.export.Template;
import forge.com.hollingsworth.schematic.mixin.StructureTemplateAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StatePos {
    public BlockState state;
    public BlockPos pos;

    public StatePos(BlockState state, BlockPos pos) {
        this.state = state;
        this.pos = pos;
    }

    public StatePos(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_("blockstate") || !compoundTag.m_128441_("blockpos")) {
            this.state = null;
            this.pos = null;
        }
        this.state = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)compoundTag.m_128469_("blockstate"));
        this.pos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("blockpos"));
    }

    public StatePos(CompoundTag compoundTag, ArrayList<BlockState> blockStates) {
        if (!compoundTag.m_128441_("blockstateshort") || !compoundTag.m_128441_("blockpos")) {
            this.state = null;
            this.pos = null;
        }
        this.state = blockStates.get(compoundTag.m_128448_("blockstateshort"));
        this.pos = BlockPos.m_122022_((long)compoundTag.m_128454_("blockpos"));
    }

    public CompoundTag getTag() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("blockstate", (Tag)NbtUtils.m_129202_((BlockState)this.state));
        compoundTag.m_128365_("blockpos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        return compoundTag;
    }

    public CompoundTag getTag(ArrayList<BlockState> blockStates) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128376_("blockstateshort", (short)blockStates.indexOf(this.state));
        compoundTag.m_128356_("blockpos", this.pos.m_121878_());
        return compoundTag;
    }

    public static ArrayList<StatePos> listFrom(StructureTemplate template) {
        StructureTemplateAccessor accessor = (StructureTemplateAccessor)template;
        ArrayList<StatePos> list = new ArrayList<StatePos>();
        List<StructureTemplate.Palette> palettes = accessor.getPalettes();
        if (palettes.isEmpty()) {
            return list;
        }
        StructureTemplate.Palette palette = palettes.get(0);
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
            list.add(new StatePos(blockInfo.f_74676_(), blockInfo.f_74675_()));
        }
        return list;
    }

    public static ArrayList<BlockState> getBlockStateMap(ArrayList<StatePos> list) {
        ArrayList<BlockState> blockStateMap = new ArrayList<BlockState>();
        for (StatePos statePos : list) {
            if (blockStateMap.contains(statePos.state)) continue;
            blockStateMap.add(statePos.state);
        }
        return blockStateMap;
    }

    public static ArrayList<StatePos> rotate(ArrayList<StatePos> list, ArrayList<TagPos> tagListMutable, Rotation rotation) {
        ArrayList<StatePos> rotatedList = new ArrayList<StatePos>();
        if (list == null || list.isEmpty()) {
            return rotatedList;
        }
        boolean tags = tagListMutable != null && !tagListMutable.isEmpty();
        Map<Object, Object> tagMap = new HashMap();
        if (tags) {
            tagMap = tagListMutable.stream().collect(Collectors.toMap(e -> e.pos, e -> e.tag));
        }
        for (StatePos statePos : list) {
            BlockPos oldPos = statePos.pos;
            BlockState oldState = statePos.state;
            BlockState newState = oldState.m_60717_(rotation);
            BlockPos newPos = oldPos.m_7954_(rotation);
            if (tags && tagMap.get(statePos.pos) != null) {
                CompoundTag tempTag = (CompoundTag)tagMap.get(statePos.pos);
                tagMap.remove(statePos.pos);
                tagMap.put(newPos, tempTag);
            }
            rotatedList.add(new StatePos(newState, newPos));
        }
        if (tags) {
            tagListMutable.clear();
            for (Map.Entry entry : tagMap.entrySet()) {
                tagListMutable.add(new TagPos((CompoundTag)entry.getValue(), (BlockPos)entry.getKey()));
            }
        }
        return rotatedList;
    }

    public static ListTag getBlockStateNBT(ArrayList<BlockState> blockStateMap) {
        ListTag listTag = new ListTag();
        for (BlockState blockState : blockStateMap) {
            listTag.add((Object)NbtUtils.m_129202_((BlockState)blockState));
        }
        return listTag;
    }

    public static ArrayList<BlockState> getBlockStateMapFromNBT(ListTag listTag) {
        ArrayList<BlockState> blockStateMap = new ArrayList<BlockState>();
        for (int i = 0; i < listTag.size(); ++i) {
            BlockState blockState = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)listTag.m_128728_(i));
            blockStateMap.add(blockState);
        }
        return blockStateMap;
    }

    public static Map<Template.ItemStackKey, Integer> getItemList(ArrayList<StatePos> list) {
        Object2IntOpenHashMap itemList = new Object2IntOpenHashMap();
        if (list == null || list.isEmpty()) {
            return itemList;
        }
        for (StatePos statePos : list) {
            BlockPos blockPos = BlockPos.f_121853_;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ItemStack cloneStack = statePos.state.m_60734_().m_7397_((BlockGetter)level, blockPos, statePos.state);
            Template.ItemStackKey itemStackKey = new Template.ItemStackKey(cloneStack, true);
            if (!itemList.containsKey(itemStackKey)) {
                itemList.put(itemStackKey, 1);
                continue;
            }
            itemList.put(itemStackKey, (Integer)itemList.get(itemStackKey) + 1);
        }
        return itemList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatePos) {
            return ((StatePos)obj).state.equals(this.state) && ((StatePos)obj).pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.state, this.pos);
    }
}

