/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.gui;

import forge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import forge.com.hollingsworth.schematic.api.blockprints.favorites.Favorite;
import forge.com.hollingsworth.schematic.api.blockprints.favorites.FavoritesResponse;
import forge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import forge.com.hollingsworth.schematic.client.gui.FavoritesRow;
import forge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import forge.com.hollingsworth.schematic.client.gui.GuiUtils;
import forge.com.hollingsworth.schematic.client.gui.HomeScreen;
import forge.com.hollingsworth.schematic.client.gui.LoadingScreen;
import forge.com.hollingsworth.schematic.client.gui.ManageVisualScreen;
import forge.com.hollingsworth.schematic.client.gui.ToggleImageButton;
import forge.com.hollingsworth.schematic.client.gui.VerticalSlider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ViewFavoritesScreen
extends BaseSchematicScreen {
    protected FavoritesResponse res = null;
    List<Favorite> favorites = new ArrayList<Favorite>();
    List<FavoritesRow> rows = new ArrayList<FavoritesRow>();
    public boolean showFavorites = true;
    public boolean showBuilds = true;
    public boolean showRecent = true;
    int scroll = 0;

    public ViewFavoritesScreen(FavoritesResponse favoritesResponse) {
        this(favoritesResponse, true, true, true);
    }

    public static LoadingScreen<FavoritesResponse> getTransition() {
        return new LoadingScreen<FavoritesResponse>(() -> BlockprintsApi.getInstance().favorites().getFavorites(), favorites -> Minecraft.m_91087_().m_91152_((Screen)new ViewFavoritesScreen((FavoritesResponse)favorites)));
    }

    public static LoadingScreen<FavoritesResponse> getTransition(ViewFavoritesScreen previousScreen) {
        return new LoadingScreen<FavoritesResponse>(() -> BlockprintsApi.getInstance().favorites().getFavorites(), favorites -> Minecraft.m_91087_().m_91152_((Screen)new ViewFavoritesScreen((FavoritesResponse)favorites, previousScreen.showFavorites, previousScreen.showBuilds, previousScreen.showRecent)), previousScreen);
    }

    public static LoadingScreen<FavoritesResponse> getTransition(boolean showFavorites, boolean showBuilds, boolean showRecent) {
        return new LoadingScreen<FavoritesResponse>(() -> BlockprintsApi.getInstance().favorites().getFavorites(showFavorites, showBuilds, showRecent), favorites -> Minecraft.m_91087_().m_91152_((Screen)new ViewFavoritesScreen((FavoritesResponse)favorites, showFavorites, showBuilds, showRecent)), null, 30);
    }

    public ViewFavoritesScreen(FavoritesResponse favoritesResponse, boolean showFavorites, boolean showBuilds, boolean showRecent) {
        this.favorites = favoritesResponse.favorites;
        this.res = favoritesResponse;
        this.showFavorites = showFavorites;
        this.showBuilds = showBuilds;
        this.showRecent = showRecent;
        this.favorites.sort((o1, o2) -> {
            if (o1.isBuild() && !o2.isBuild()) {
                return -1;
            }
            if (!o1.isBuild() && o2.isBuild()) {
                return 1;
            }
            if (o1.isFavorite() && !o2.isFavorite()) {
                return -1;
            }
            if (!o1.isFavorite() && o2.isFavorite()) {
                return 1;
            }
            if (o1.isRecent() && !o2.isRecent()) {
                return -1;
            }
            if (!o1.isRecent() && o2.isRecent()) {
                return 1;
            }
            return o1.name().compareTo(o2.name());
        });
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.updateList();
        int scrollSize = Math.max(0, this.favorites.size() - 10);
        this.m_142416_(new VerticalSlider(this.bookLeft + 265, this.bookTop + 46, scrollSize, 1.0, 1, count -> {
            this.scroll = count;
            this.updateList();
        }));
        ResourceLocation unchecked = new ResourceLocation("blockprints", "textures/gui/container_filter_unchecked.png");
        ResourceLocation checked = new ResourceLocation("blockprints", "textures/gui/container_filter_checked.png");
        this.m_142416_(new ToggleImageButton(this.bookLeft + 206, this.bookTop + 29, 7, 7, unchecked, checked, b -> {
            this.showBuilds = !this.showBuilds;
            this.queryFavorites();
        }, () -> this.showBuilds).withTooltip((Component)Component.m_237115_((String)"blockprints.filter_own_builds")));
        this.m_142416_(new ToggleImageButton(this.bookLeft + 224, this.bookTop + 29, 7, 7, unchecked, checked, b -> {
            this.showFavorites = !this.showFavorites;
            this.queryFavorites();
        }, () -> this.showFavorites).withTooltip((Component)Component.m_237115_((String)"blockprints.filter_favorites")));
        this.m_142416_(new ToggleImageButton(this.bookLeft + 244, this.bookTop + 29, 7, 7, unchecked, checked, b -> {
            this.showRecent = !this.showRecent;
            this.queryFavorites();
        }, () -> this.showRecent).withTooltip((Component)Component.m_237115_((String)"blockprints.filter_recent_builds")));
        this.m_142416_(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new ResourceLocation("blockprints", "textures/gui/button_back.png"), b -> Minecraft.m_91087_().m_91152_((Screen)new HomeScreen())));
        this.m_142416_(new GuiImageButton(this.bookLeft + 25, this.bookTop + 9, 79, 15, new ResourceLocation("blockprints", "textures/gui/button_5.png"), b -> Minecraft.m_91087_().m_91152_((Screen)new ManageVisualScreen()))).withTooltip((Component)Component.m_237115_((String)"blockprints.visualize_list_tooltip"));
    }

    public void updateList() {
        for (FavoritesRow row : this.rows) {
            this.m_169411_((GuiEventListener)row);
        }
        this.rows = new ArrayList<FavoritesRow>();
        List<Favorite> sliced = this.favorites.subList(this.scroll, Math.min(this.scroll + 10, this.favorites.size()));
        for (int i = 0; i < Math.min(sliced.size(), 10); ++i) {
            Favorite entry = sliced.get(i);
            FavoritesRow row = new FavoritesRow(this.bookLeft + 26, this.bookTop + 44 + i * 14, entry, this);
            this.rows.add(row);
            this.m_142416_(row);
        }
    }

    public void queryFavorites() {
        Minecraft.m_91087_().m_91152_(ViewFavoritesScreen.getTransition(this.showFavorites, this.showBuilds, this.showRecent));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_visualize.png"), this.bookLeft + 28, this.bookTop + 13, 0.0f, 0.0f, 9, 7, 9, 7);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.visual_list").m_7532_(), this.bookLeft + 70, this.bookTop + 13);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/container_list_builds.png"), 25, 25, 0.0f, 0.0f, 239, 159, 239, 159);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_my_builds.png"), 214, 29, 0.0f, 0.0f, 5, 7, 5, 7);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_favorite_builds.png"), 232, 29, 0.0f, 0.0f, 7, 7, 7, 7);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_recent_builds.png"), 252, 29, 0.0f, 0.0f, 7, 7, 7, 7);
        GuiUtils.drawOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.builds").m_7532_(), 30, 29);
    }
}

