/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.gui;

import forge.com.hollingsworth.schematic.api.SceneExporter;
import forge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import forge.com.hollingsworth.schematic.client.gui.CheckBoxButton;
import forge.com.hollingsworth.schematic.client.gui.GimbalButton;
import forge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import forge.com.hollingsworth.schematic.client.gui.GuiUtils;
import forge.com.hollingsworth.schematic.client.gui.HomeScreen;
import forge.com.hollingsworth.schematic.client.gui.HorizontalSlider;
import forge.com.hollingsworth.schematic.client.gui.LoadingScreen;
import forge.com.hollingsworth.schematic.client.gui.NoScrollMultiText;
import forge.com.hollingsworth.schematic.client.gui.ScenePreview;
import forge.com.hollingsworth.schematic.client.gui.ShortTextField;
import forge.com.hollingsworth.schematic.common.util.ClientUtil;
import forge.com.hollingsworth.schematic.export.CameraSettings;
import forge.com.hollingsworth.schematic.export.Scene;
import forge.com.hollingsworth.schematic.export.WrappedScene;
import forge.com.hollingsworth.schematic.export.level.GuidebookLevel;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class UploadPreviewScreen
extends BaseSchematicScreen {
    ScenePreview scenePreview;
    HorizontalSlider yawSlider;
    HorizontalSlider pitchSlider;
    ShortTextField nameField;
    NoScrollMultiText descriptionField;
    GuiImageButton uploadButton;
    public StructureTemplate structureTemplate;
    public static final int MAX_NAME_LENGTH = 100;
    public static final int MIN_NAME_LENGTH = 10;
    public static final int MAX_DESC_LENGTH = 1000;
    public static final int MIN_DESC_LENGTH = 20;
    public boolean makePublic = false;
    public BlockPos start;
    public BlockPos end;

    public UploadPreviewScreen(StructureTemplate structureTemplate, BlockPos start, BlockPos end) {
        this.structureTemplate = structureTemplate;
        this.start = start;
        this.end = end;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        WrappedScene wrappedScene = new WrappedScene();
        Scene scene = new Scene(new GuidebookLevel(), new CameraSettings());
        wrappedScene.setScene(scene);
        wrappedScene.placeStructure(this.structureTemplate);
        this.nameField = new ShortTextField(this.f_96547_, this.bookLeft + 185, this.bookTop + 39, (Component)Component.m_237119_());
        this.descriptionField = new NoScrollMultiText(this.f_96547_, this.bookLeft + 185, this.bookTop + 71, 95, 81, (Component)Component.m_237119_(), (Component)Component.m_237119_());
        this.uploadButton = new GuiImageButton(this.bookRight - 119, this.bookTop + 169, 95, 15, new ResourceLocation("blockprints", "textures/gui/button_6.png"), b -> {
            String name = this.nameField.m_94155_().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100 || name.length() < 10 || desc.length() > 1000 || desc.length() < 20) {
                return;
            }
            SceneExporter sceneExporter = new SceneExporter(wrappedScene, this.structureTemplate);
            if (sceneExporter.scene.getSizeForExport(2.0f) == null) {
                Minecraft.m_91087_().m_91152_(null);
                ClientUtil.sendMessage((Component)Component.m_237115_((String)"blockprints.invalid_upload").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                return;
            }
            List<WrappedScene.ImageExport> images = sceneExporter.getImages();
            Minecraft.m_91087_().m_91152_(new LoadingScreen<String>(() -> sceneExporter.writeAndUpload(images, this.nameField.m_94155_(), this.descriptionField.getValue(), this.makePublic, this.start, this.end), res -> {
                Minecraft.m_91087_().m_91152_(null);
                String url = "https://blockprints.io/schematic/" + res;
                ClientUtil.sendMessage((Component)Component.m_237110_((String)"blockprints.upload_complete", (Object[])new Object[]{Component.m_237113_((String)url).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)))}));
            }));
        });
        this.m_142416_(this.uploadButton);
        this.m_142416_(this.nameField);
        this.m_142416_(this.descriptionField);
        this.yawSlider = new HorizontalSlider(this.bookLeft + 41, this.bookTop + 153, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.0, 360.0, 225.0, 5.0, 1, false, this::setYaw);
        this.pitchSlider = new HorizontalSlider(this.bookLeft + 41, this.bookTop + 169, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.0, 90.0, 30.0, 5.0, 1, true, this::setPitch);
        this.m_142416_(this.yawSlider);
        this.m_142416_(this.pitchSlider);
        this.scenePreview = new ScenePreview(this.bookLeft + 25, this.bookTop + 41, 100, 100, scene, wrappedScene);
        this.scenePreview.yaw = 225;
        this.scenePreview.pitch = 30;
        this.m_142416_(this.scenePreview);
        this.m_142416_(new GimbalButton(this.bookLeft + 155, this.bookTop + 47, "northeast", b -> {
            this.setYaw(225);
            this.setPitch(30);
        }));
        this.m_142416_(new GimbalButton(this.bookLeft + 149, this.bookTop + 47, "northwest", b -> {
            this.setYaw(135);
            this.setPitch(30);
        }));
        this.m_142416_(new GimbalButton(this.bookLeft + 149, this.bookTop + 53, "southwest", b -> {
            this.setYaw(45);
            this.setPitch(30);
        }));
        this.m_142416_(new GimbalButton(this.bookLeft + 155, this.bookTop + 53, "southeast", b -> {
            this.setYaw(315);
            this.setPitch(30);
        }));
        this.m_142416_(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new ResourceLocation("blockprints", "textures/gui/button_back.png"), b -> Minecraft.m_91087_().m_91152_((Screen)new HomeScreen())));
        this.m_142416_(new CheckBoxButton(this.bookRight - 119, this.bookTop + 153, b -> {
            this.makePublic = !this.makePublic;
        }, () -> this.makePublic).withTooltip((Component)Component.m_237115_((String)"blockprints.make_public_tooltip")));
    }

    public void m_7861_() {
        super.m_7861_();
        this.scenePreview.removed();
    }

    public void setYaw(int yaw) {
        this.scenePreview.yaw = yaw;
        this.yawSlider.m_93611_(yaw);
    }

    public void setPitch(int pitch) {
        this.scenePreview.pitch = pitch;
        this.pitchSlider.m_93611_(pitch);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_upload.png"), this.bookRight - 116, this.bookTop + 171, 0.0f, 0.0f, 9, 11, 9, 11);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.make_public").m_7532_(), this.bookRight - 67, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.upload").m_7532_(), this.bookRight - 67, this.bookTop + 173);
    }

    @Override
    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        super.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, (AbstractWidget)this.uploadButton)) {
            String name = this.nameField.m_94155_().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100) {
                tooltip.add((Component)Component.m_237115_((String)"blockprints.name_too_long"));
            }
            if (name.length() < 10) {
                tooltip.add((Component)Component.m_237115_((String)"blockprints.name_too_short"));
            }
            if (desc.length() > 1000) {
                tooltip.add((Component)Component.m_237115_((String)"blockprints.description_too_long"));
            }
            if (desc.length() < 20) {
                tooltip.add((Component)Component.m_237115_((String)"blockprints.description_too_short"));
            }
        }
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/diologue_preview.png"), 25, 25, 0.0f, 0.0f, 143, 127, 143, 127);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/diologue_title.png"), 185, 25, 0.0f, 0.0f, 95, 14, 95, 14);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/diologue_title.png"), 185, 57, 0.0f, 0.0f, 95, 14, 95, 14);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.set_preview").m_7532_(), 96, 29);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.name").m_7532_(), 233, 29);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.description").m_7532_(), 233, 61);
    }
}

