/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import forge.com.hollingsworth.schematic.client.gui.ModScreen;
import forge.com.hollingsworth.schematic.export.LytSize;
import forge.com.hollingsworth.schematic.export.OffScreenRenderer;
import forge.com.hollingsworth.schematic.export.Scene;
import forge.com.hollingsworth.schematic.export.WrappedScene;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ScenePreview
extends AbstractWidget {
    public int yaw = 225;
    public int pitch = 30;
    public int roll;
    public WrappedScene wrappedScene;
    public Scene scene;
    public OffScreenRenderer renderer;

    public ScenePreview(int x, int y, int width, int height, Scene scene, WrappedScene wrappedScene) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.wrappedScene = wrappedScene;
        this.scene = scene;
    }

    public void updateSceneTexture() {
        this.scene.getCameraSettings().setIsometricYawPitchRoll(this.yaw, this.pitch, this.roll);
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(1.0f);
        this.scene.centerScene();
        LytSize prefSize = this.wrappedScene.getPreferredSize();
        float scale = (float)Minecraft.m_91087_().m_91268_().m_85449_();
        if (prefSize.width() > 0 && prefSize.height() > 0) {
            int renderWidth = (int)Math.max(1.0f, (float)prefSize.width() * scale);
            int renderHeight = (int)Math.max(1.0f, (float)prefSize.height() * scale);
            if (this.renderer == null || this.renderer.width != renderWidth || this.renderer.height != renderHeight) {
                if (this.renderer != null) {
                    this.renderer.close();
                }
                this.renderer = new OffScreenRenderer(renderWidth, renderHeight);
            }
            this.renderer.renderToTexture(this::renderTarget);
        }
    }

    public void renderTarget() {
        this.wrappedScene.renderToCurrentTarget(this.wrappedScene.getPreferredSize());
    }

    public void removed() {
        if (this.renderer != null) {
            this.renderer.close();
            this.renderer = null;
        }
    }

    protected void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.updateSceneTexture();
        int previewX = this.f_93620_;
        int previewY = this.f_93621_;
        if (this.renderer != null) {
            int imageWidth = this.renderer.width;
            int imageHeight = this.renderer.height;
            LytSize origDim = new LytSize(imageWidth, imageHeight);
            LytSize boundary = new LytSize(this.f_93618_, this.f_93619_);
            LytSize newDim = ScenePreview.getScaledDimension(origDim, boundary);
            int x = previewX + 71;
            int y = previewY + 55;
            this.innerBlit(graphics.m_280168_(), this.renderer, x -= newDim.width() / 2, x + newDim.width(), y -= newDim.height() / 2, y + newDim.height(), 0);
        }
        ModScreen.blitRect(graphics.m_280168_(), this.f_93620_ + 121, this.f_93621_ + 3, 0.0f, 0.0f, 17.0f, 17.0f, 17, 17, new ResourceLocation("blockprints", "textures/gui/gimbal/gimbal_cardinal.png"), 150);
    }

    void innerBlit(PoseStack pose, OffScreenRenderer osr, int x1, int x2, int y1, int y2, int blitOffset) {
        RenderSystem.setShaderTexture((int)0, (int)osr.fb.m_83975_());
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y1, (float)blitOffset).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y2, (float)blitOffset).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y2, (float)blitOffset).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y1, (float)blitOffset).m_7421_(1.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static LytSize getScaledDimension(LytSize imgSize, LytSize boundary) {
        int original_width = imgSize.width();
        int original_height = imgSize.height();
        int bound_width = boundary.width();
        int bound_height = boundary.height();
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new LytSize(new_width, new_height);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_7435_(SoundManager $$0) {
    }
}

