/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.gui;

import forge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import forge.com.hollingsworth.schematic.api.blockprints.download.PreviewDownloadResult;
import forge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import forge.com.hollingsworth.schematic.client.gui.CheckBoxButton;
import forge.com.hollingsworth.schematic.client.gui.ConfirmDeleteScreen;
import forge.com.hollingsworth.schematic.client.gui.DownloadScreen;
import forge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import forge.com.hollingsworth.schematic.client.gui.GuiUtils;
import forge.com.hollingsworth.schematic.client.gui.LoadingScreen;
import forge.com.hollingsworth.schematic.client.gui.NoScrollMultiText;
import forge.com.hollingsworth.schematic.client.gui.PreviewImage;
import forge.com.hollingsworth.schematic.client.gui.ShortTextField;
import forge.com.hollingsworth.schematic.client.gui.ViewFavoritesScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EditBuildScreen
extends BaseSchematicScreen {
    DynamicTexture dynamicTexture;
    PreviewDownloadResult preview;
    ViewFavoritesScreen previousScreen;
    ShortTextField nameField;
    NoScrollMultiText descriptionField;
    GuiImageButton uploadButton;
    GuiImageButton deleteButton;
    public boolean makePublic = false;

    public EditBuildScreen(ViewFavoritesScreen previousScreen, PreviewDownloadResult preview) {
        this.previousScreen = previousScreen;
        this.preview = preview;
        this.makePublic = preview.downloadResponse.isPublic;
    }

    public static LoadingScreen<PreviewDownloadResult> getTransition(String code, ViewFavoritesScreen previousScreen) {
        return new LoadingScreen<PreviewDownloadResult>(() -> BlockprintsApi.getInstance().download().downloadPreview(code), build -> Minecraft.m_91087_().m_91152_((Screen)new EditBuildScreen(previousScreen, (PreviewDownloadResult)build)), previousScreen);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        try {
            this.dynamicTexture = DownloadScreen.getTexture(this.preview);
            Minecraft.m_91087_().m_91097_().m_118495_(DownloadScreen.PREVIEW_TEXTURE, (AbstractTexture)this.dynamicTexture);
            this.m_142416_(new PreviewImage(this.bookLeft + 25, this.bookTop + 41, 100, 100, this.dynamicTexture, DownloadScreen.PREVIEW_TEXTURE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nameField = new ShortTextField(this.f_96547_, this.bookLeft + 185, this.bookTop + 39, (Component)Component.m_237119_());
        this.descriptionField = new NoScrollMultiText(this.f_96547_, this.bookLeft + 185, this.bookTop + 71, 95, 81, (Component)Component.m_237119_(), (Component)Component.m_237119_());
        this.nameField.m_94144_(this.preview.downloadResponse.structureName);
        this.descriptionField.setValue(this.preview.downloadResponse.description);
        this.uploadButton = new GuiImageButton(this.bookRight - 119, this.bookTop + 169, 79, 15, new ResourceLocation("blockprints", "textures/gui/button_5.png"), b -> {
            String name = this.nameField.m_94155_().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100 || name.length() < 10 || desc.length() > 1000 || desc.length() < 20) {
                return;
            }
            Minecraft.m_91087_().m_91152_(new LoadingScreen<Boolean>(() -> BlockprintsApi.getInstance().upload().postEdit(this.preview.downloadResponse.id, name, desc, this.makePublic), build -> Minecraft.m_91087_().m_91152_(ViewFavoritesScreen.getTransition(this.previousScreen)), this));
        });
        this.deleteButton = new GuiImageButton(this.bookRight - 39, this.bookTop + 169, 15, 15, new ResourceLocation("blockprints", "textures/gui/button_delete.png"), b -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmDeleteScreen(this.preview, ViewFavoritesScreen.getTransition(this.previousScreen), this))).withTooltip((Component)Component.m_237115_((String)"blockprints.delete_tooltip"));
        this.m_142416_(this.uploadButton);
        this.m_142416_(this.deleteButton);
        this.m_142416_(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new ResourceLocation("blockprints", "textures/gui/button_back.png"), b -> Minecraft.m_91087_().m_91152_((Screen)this.previousScreen)));
        this.m_142416_(this.nameField);
        this.m_142416_(this.descriptionField);
        this.m_142416_(new CheckBoxButton(this.bookRight - 119, this.bookTop + 153, b -> {
            this.makePublic = !this.makePublic;
        }, () -> this.makePublic).withTooltip((Component)Component.m_237115_((String)"blockprints.make_public_tooltip")));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/icon_upload.png"), this.bookRight - 116, this.bookTop + 171, 0.0f, 0.0f, 9, 11, 9, 11);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.make_public").m_7532_(), this.bookRight - 67, this.bookTop + 157);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.save").m_7532_(), this.bookRight - 70, this.bookTop + 173);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/diologue_preview.png"), 25, 25, 0.0f, 0.0f, 143, 127, 143, 127);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/diologue_title.png"), 185, 25, 0.0f, 0.0f, 95, 14, 95, 14);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/diologue_title.png"), 185, 57, 0.0f, 0.0f, 95, 14, 95, 14);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.preview").m_7532_(), 96, 29);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.name").m_7532_(), 233, 29);
        GuiUtils.drawCenteredOutlinedText(this.f_96547_, graphics, Component.m_237115_((String)"blockprints.description").m_7532_(), 233, 61);
    }

    public void m_7861_() {
        super.m_7861_();
        Minecraft.m_91087_().m_91097_().m_118513_(DownloadScreen.PREVIEW_TEXTURE);
    }

    @Override
    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        super.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, (AbstractWidget)this.uploadButton)) {
            String name = this.nameField.m_94155_().trim();
            String desc = this.descriptionField.getValue().trim();
            if (name.length() > 100) {
                tooltip.add((Component)Component.m_237115_((String)"blockprints.name_too_long"));
            }
            if (name.length() < 10) {
                tooltip.add((Component)Component.m_237115_((String)"blockprints.name_too_short"));
            }
            if (desc.length() > 1000) {
                tooltip.add((Component)Component.m_237115_((String)"blockprints.description_too_long"));
            }
            if (desc.length() < 20) {
                tooltip.add((Component)Component.m_237115_((String)"blockprints.description_too_short"));
            }
        }
    }
}

