/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client.gui;

import forge.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import forge.com.hollingsworth.schematic.client.gui.BlockEntryRow;
import forge.com.hollingsworth.schematic.client.gui.DownloadScreen;
import forge.com.hollingsworth.schematic.client.gui.GuiImageButton;
import forge.com.hollingsworth.schematic.client.gui.VerticalSlider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BlockListScreen
extends BaseSchematicScreen {
    public Screen previousScreen;
    List<DownloadScreen.BlockListEntry> entries;
    List<BlockEntryRow> rows = new ArrayList<BlockEntryRow>();
    int scroll = 0;

    public BlockListScreen(Screen previousScreen, List<DownloadScreen.BlockListEntry> entries) {
        this.previousScreen = previousScreen;
        this.entries = entries;
        this.entries.sort((o1, o2) -> {
            if (o1.isMissing && !o2.isMissing) {
                return -1;
            }
            if (!o1.isMissing && o2.isMissing) {
                return 1;
            }
            return Integer.compare(o2.count, o1.count);
        });
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new ResourceLocation("blockprints", "textures/gui/button_back.png"), b -> Minecraft.m_91087_().m_91152_(this.previousScreen)));
        this.updateList();
        int scrollSize = Math.max(0, this.entries.size() - 10);
        this.m_142416_(new VerticalSlider(this.bookLeft + 265, this.bookTop + 46, scrollSize, 1.0, 1, count -> {
            this.scroll = count;
            this.updateList();
        }));
    }

    public void updateList() {
        for (BlockEntryRow row : this.rows) {
            this.m_169411_((GuiEventListener)row);
        }
        this.rows = new ArrayList<BlockEntryRow>();
        List<DownloadScreen.BlockListEntry> sliced = this.entries.subList(this.scroll, Math.min(this.scroll + 10, this.entries.size()));
        for (int i = 0; i < Math.min(sliced.size(), 10); ++i) {
            DownloadScreen.BlockListEntry entry = sliced.get(i);
            BlockEntryRow row = new BlockEntryRow(this.bookLeft + 25, this.bookTop + 43 + i * 14, entry);
            this.rows.add(row);
            this.m_142416_(row);
        }
    }

    @Override
    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("blockprints", "textures/gui/container_list_blocks.png"), 25, 25, 0.0f, 0.0f, 239, 159, 239, 159);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"blockprints.block"), 30, 29, 0, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"blockprints.qty"), 235, 29, 0, false);
    }
}

