/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forge.com.hollingsworth.schematic.client.TintedVertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final RenderType TRANSLUCENT = RenderType.m_110473_((ResourceLocation)TextureAtlas.f_118259_);
    private static final Matrix4f SCALE_INVERT_Y = new Matrix4f().scaling(1.0f, -1.0f, 1.0f);

    public static void drawItemAsIcon(ItemStack stack, PoseStack poseStack, float x, float y, float scale) {
        if (stack.m_41619_()) {
            return;
        }
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = renderer.m_174264_(stack, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        RenderUtils.renderItemModel(poseStack, stack, x, y, scale, 0, model, renderer, 150);
    }

    private static MultiBufferSource transparentBuffer(MultiBufferSource buffer) {
        return renderType -> new TintedVertexConsumer(buffer.m_6299_(TRANSLUCENT), 1.0f, 1.0f, 1.0f, 0.25f);
    }

    public static void renderItemModel(PoseStack poseStack, ItemStack stack, float x, float y, float scale, int alpha, BakedModel model, ItemRenderer renderer, int zIndex) {
        boolean flatLight;
        poseStack.m_85836_();
        poseStack.m_252880_(x + 8.0f, y + 8.0f, (float)zIndex);
        poseStack.m_252931_(SCALE_INVERT_Y);
        poseStack.m_85841_(scale, scale, scale);
        boolean bl = flatLight = !model.m_7547_();
        if (flatLight) {
            Lighting.m_84930_();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        renderer.m_115143_(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
    }
}

