/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client;

import com.mojang.blaze3d.platform.Window;
import forge.com.hollingsworth.schematic.client.ClientData;
import forge.com.hollingsworth.schematic.client.RaycastHelper;
import forge.com.hollingsworth.schematic.client.gui.GuiUtils;
import forge.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import forge.com.hollingsworth.schematic.client.renderer.StructureRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RenderStructureHandler {
    public static BlockPos anchorPos;
    public static StructureRenderData placingData;

    public static void startRender(StructureTemplate structureTemplate, String name, String bpId) {
        if (placingData != null) {
            RenderStructureHandler.cancelRender();
        }
        anchorPos = null;
        placingData = new StructureRenderData(structureTemplate, name, bpId);
        StructureRenderer.structures.add(placingData);
    }

    public static void cancelRender() {
        if (placingData == null) {
            return;
        }
        anchorPos = null;
        StructureRenderer.structures.remove(placingData);
        placingData = null;
    }

    public static void onConfirmHit() {
        if (placingData == null) {
            return;
        }
        placingData = null;
    }

    public static void onCancelHit() {
        if (placingData == null) {
            return;
        }
        RenderStructureHandler.cancelRender();
    }

    public static void positionClicked() {
        if (placingData == null) {
            return;
        }
        RenderStructureHandler.placingData.anchorPos = RaycastHelper.getLookingAt((Player)Minecraft.m_91087_().f_91074_, true).m_82425_();
    }

    public static void onRotateHit(boolean clockwise) {
        if (placingData == null) {
            return;
        }
        placingData.rotate(clockwise ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
    }

    public static void onMirrorHit() {
        if (placingData == null) {
            return;
        }
        placingData.mirror(true);
    }

    public static void renderInstructions(GuiGraphics graphics, Window window) {
        if (placingData == null) {
            return;
        }
        float screenY = (float)window.m_85446_() / 2.0f;
        float screenX = (float)window.m_85445_() / 2.0f;
        float instructionY = window.m_85446_() - 42;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(screenX, instructionY, 0.0f);
        GuiUtils.drawCenteredOutlinedText(Minecraft.m_91087_().f_91062_, graphics, Component.m_237110_((String)"blockprints.confirm_selection", (Object[])new Object[]{ClientData.CONFIRM.m_90863_()}).m_7532_(), 0, 0);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(screenX, instructionY + 10.0f, 0.0f);
        GuiUtils.drawCenteredOutlinedText(Minecraft.m_91087_().f_91062_, graphics, Component.m_237110_((String)"blockprints.cancel_selection", (Object[])new Object[]{ClientData.CANCEL.m_90863_()}).m_7532_(), 0, 0);
        graphics.m_280168_().m_85849_();
    }
}

