/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.com.hollingsworth.schematic.ClientConstants;
import forge.com.hollingsworth.schematic.client.ClientData;
import forge.com.hollingsworth.schematic.client.RaycastHelper;
import forge.com.hollingsworth.schematic.client.gui.GuiUtils;
import forge.com.hollingsworth.schematic.client.gui.UploadPreviewScreen;
import forge.com.hollingsworth.schematic.common.util.SchematicExport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AreaCaptureHandler {
    public static BlockPos firstTarget;
    public static BlockPos secondTarget;
    public static boolean showBoundary;
    public static BlockPos selectedPos;

    public static void startCapture() {
        showBoundary = true;
        firstTarget = null;
        secondTarget = null;
    }

    public static void cancelCapture() {
        showBoundary = false;
        firstTarget = null;
        secondTarget = null;
    }

    public static void onConfirmHit() {
        if (!showBoundary) {
            return;
        }
        showBoundary = false;
        if (firstTarget != null && secondTarget != null) {
            StructureTemplate structure = SchematicExport.getStructure((Level)Minecraft.m_91087_().f_91073_, firstTarget, secondTarget);
            Minecraft.m_91087_().m_91152_((Screen)new UploadPreviewScreen(structure, firstTarget, secondTarget));
        }
    }

    public static void onCancelHit() {
        if (!showBoundary) {
            return;
        }
        AreaCaptureHandler.cancelCapture();
    }

    public static void renderBoundary(PoseStack poseStack) {
        if (!showBoundary) {
            return;
        }
        BlockPos firstPos = firstTarget;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BlockHitResult trace = RaycastHelper.rayTraceRange(player.m_9236_(), (Player)player, 75.0);
        if (trace.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hit = trace.m_82425_();
            boolean replaceable = player.m_9236_().m_8055_(hit).m_60629_(new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, trace)));
            if (trace.m_82434_().m_122434_().m_122478_() && !replaceable) {
                hit = hit.m_121945_(trace.m_82434_());
            }
            selectedPos = hit;
        } else {
            selectedPos = null;
        }
        if (firstPos == null && selectedPos != null) {
            AreaCaptureHandler.renderBbox(new AABB(selectedPos), poseStack);
            return;
        }
        BlockPos secondPos = secondTarget;
        if (secondPos == null) {
            secondPos = selectedPos;
        }
        AABB currentSelectionBox = null;
        currentSelectionBox = secondPos == null ? (firstPos == null ? (selectedPos == null ? null : new AABB(selectedPos)) : (selectedPos == null ? new AABB(firstPos) : new AABB(firstPos, selectedPos).m_82363_(1.0, 1.0, 1.0))) : new AABB(firstPos, secondPos).m_82363_(1.0, 1.0, 1.0);
        AreaCaptureHandler.renderBbox(currentSelectionBox, poseStack);
    }

    public static void renderBbox(AABB currentSelectionBox, PoseStack poseStack) {
        if (currentSelectionBox == null) {
            return;
        }
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        currentSelectionBox.m_82383_(camera.m_82490_(-1.0));
        currentSelectionBox = currentSelectionBox.m_82386_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        poseStack.m_85836_();
        VertexConsumer vertexconsumer = ClientConstants.bufferSource.m_6299_(RenderType.m_110504_());
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (AABB)currentSelectionBox, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        ClientConstants.bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    public static boolean positionClicked() {
        if (!showBoundary) {
            return false;
        }
        BlockPos pos = selectedPos;
        if (pos == null) {
            return false;
        }
        if (firstTarget == null) {
            firstTarget = pos.m_7949_();
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"blockprints.select_second"));
            return true;
        }
        if (secondTarget == null && !firstTarget.equals((Object)pos)) {
            secondTarget = pos.m_7949_();
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237110_((String)"blockprints.confirm_selection", (Object[])new Object[]{ClientData.CONFIRM.m_90863_()}));
            return true;
        }
        return false;
    }

    public static void renderBoundaryUI(GuiGraphics graphics, Window window) {
        if (!showBoundary) {
            return;
        }
        float screenY = (float)window.m_85446_() / 2.0f;
        float screenX = (float)window.m_85445_() / 2.0f;
        float instructionY = window.m_85446_() - 42;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(screenX, instructionY, 0.0f);
        if (firstTarget != null && secondTarget != null) {
            GuiUtils.drawCenteredOutlinedText(Minecraft.m_91087_().f_91062_, graphics, Component.m_237110_((String)"blockprints.confirm_selection", (Object[])new Object[]{ClientData.CONFIRM.m_90863_()}).m_7532_(), 0, 0);
        } else {
            String compKey = firstTarget == null ? "select_first" : "select_second";
            GuiUtils.drawCenteredOutlinedText(Minecraft.m_91087_().f_91062_, graphics, Component.m_237115_((String)("blockprints." + compKey)).m_7532_(), 0, 0);
        }
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(screenX, instructionY + 10.0f, 0.0f);
        GuiUtils.drawCenteredOutlinedText(Minecraft.m_91087_().f_91062_, graphics, Component.m_237110_((String)"blockprints.cancel_selection", (Object[])new Object[]{ClientData.CANCEL.m_90863_()}).m_7532_(), 0, 0);
        graphics.m_280168_().m_85849_();
    }

    static {
        selectedPos = null;
    }
}

