/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.api.blockprints.upload;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.com.hollingsworth.schematic.api.blockprints.ApiResponse;
import forge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import forge.com.hollingsworth.schematic.api.blockprints.RequestUtil;
import forge.com.hollingsworth.schematic.api.blockprints.upload.UploadResponse;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class Upload {
    private final BlockprintsApi api;
    private final HttpClient CLIENT;

    public Upload(BlockprintsApi api) {
        this.api = api;
        this.CLIENT = this.api.CLIENT;
    }

    public ApiResponse<UploadResponse> postUpload(String name, String description, String json, boolean makePublic) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("description", description);
        jsonObject.addProperty("makePublic", Boolean.valueOf(makePublic));
        jsonObject.addProperty("json", json);
        HttpRequest request = this.api.getBuilder().uri(RequestUtil.getRoute("/api/v1/upload")).POST(HttpRequest.BodyPublishers.ofString(jsonObject.toString())).build();
        try {
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (!RequestUtil.responseSuccessful(res.statusCode())) {
                return ApiResponse.parseServerError(res);
            }
            JsonObject responseObj = JsonParser.parseString((String)res.body()).getAsJsonObject();
            return ApiResponse.success(new UploadResponse(responseObj));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.connectionError();
        }
    }

    public ApiResponse<Boolean> postEdit(String id, String name, String description, boolean makePublic) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", name);
        jsonObject.addProperty("description", description);
        jsonObject.addProperty("makePublic", Boolean.valueOf(makePublic));
        HttpRequest request = this.api.getBuilder().uri(RequestUtil.getRoute("/api/v1/upload/" + id)).PUT(HttpRequest.BodyPublishers.ofString(jsonObject.toString())).build();
        try {
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (!RequestUtil.responseSuccessful(res.statusCode())) {
                return ApiResponse.parseServerError(res);
            }
            return ApiResponse.success();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return ApiResponse.connectionError();
        }
    }

    public ApiResponse<Boolean> postDoneUploading(String id) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", id);
        HttpRequest request = this.api.getBuilder().uri(RequestUtil.getRoute("/api/v1/upload/complete")).POST(HttpRequest.BodyPublishers.ofString(jsonObject.toString())).build();
        try {
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (!RequestUtil.responseSuccessful(res.statusCode())) {
                return ApiResponse.parseServerError(res);
            }
            return ApiResponse.success();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return ApiResponse.connectionError();
        }
    }

    public ApiResponse<Boolean> postDelete(String id) {
        HttpRequest request = this.api.getBuilder(false).uri(RequestUtil.getRoute("/api/v1/upload/" + id)).DELETE().build();
        try {
            HttpResponse<String> res = this.CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (!RequestUtil.responseSuccessful(res.statusCode())) {
                return ApiResponse.parseServerError(res);
            }
            return ApiResponse.success();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return ApiResponse.connectionError();
        }
    }
}

