/*
 * Decompiled with CFR 0.152.
 */
package forge.com.hollingsworth.schematic.api;

import forge.com.hollingsworth.schematic.api.blockprints.ApiError;
import forge.com.hollingsworth.schematic.api.blockprints.ApiResponse;
import forge.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import forge.com.hollingsworth.schematic.api.blockprints.GoogleCloudStorage;
import forge.com.hollingsworth.schematic.api.blockprints.upload.UploadResponse;
import forge.com.hollingsworth.schematic.common.util.SchematicExport;
import forge.com.hollingsworth.schematic.export.PerspectivePreset;
import forge.com.hollingsworth.schematic.export.Template;
import forge.com.hollingsworth.schematic.export.WrappedScene;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SceneExporter {
    public static final String IMAGE_FOLDER = "./schematics/blockprints/images/";
    public static final String STRUCTURE_FOLDER = "./schematics/";
    public static final int GAMESCENE_PLACEHOLDER_SCALE = 2;
    public WrappedScene scene;
    public StructureTemplate structureTemplate;

    public SceneExporter(WrappedScene wrappedScene, StructureTemplate structureTemplate) {
        this.scene = wrappedScene;
        this.structureTemplate = structureTemplate;
    }

    public List<WrappedScene.ImageExport> getImages() {
        ArrayList<WrappedScene.ImageExport> images = new ArrayList<WrappedScene.ImageExport>();
        images.add(this.scene.exportPreviewPng());
        images.add(this.scene.exportPreviewPng());
        PerspectivePreset[] perspectivePresets = PerspectivePreset.values();
        float currentYaw = this.scene.scene.getCameraSettings().getRotationY();
        float currentPitch = this.scene.scene.getCameraSettings().getRotationX();
        float currentRoll = this.scene.scene.getCameraSettings().getRotationZ();
        PerspectivePreset closest = PerspectivePreset.ISOMETRIC_NORTH_EAST;
        float closestDistance = Float.MAX_VALUE;
        for (PerspectivePreset preset : perspectivePresets) {
            float yaw = preset.yaw();
            float pitch = preset.pitch();
            float roll = preset.roll();
            float distance = (float)Math.sqrt(Math.pow(currentYaw - yaw, 2.0) + Math.pow(currentPitch - pitch, 2.0) + Math.pow(currentRoll - roll, 2.0));
            if (!(distance < closestDistance)) continue;
            closest = preset;
            closestDistance = distance;
        }
        for (PerspectivePreset preset : perspectivePresets) {
            if (preset == closest) continue;
            this.scene.scene.getCameraSettings().setPerspectivePreset(preset);
            this.scene.scene.getCameraSettings().setRotationCenter(this.scene.scene.getWorldCenter());
            this.scene.scene.getCameraSettings().setZoom(1.0f);
            this.scene.scene.centerScene();
            images.add(this.scene.exportPreviewPng());
        }
        return images;
    }

    public ApiResponse<String> writeAndUpload(List<WrappedScene.ImageExport> images, String name, String description, boolean makePublic, BlockPos start, BlockPos end) {
        String finalExportName = SceneExporter.sanitize(name);
        try {
            Files.createDirectories(Path.of(IMAGE_FOLDER, new String[0]), new FileAttribute[0]);
            int count = 0;
            ArrayList<Path> imageFiles = new ArrayList<Path>();
            Path previewPath = Paths.get(IMAGE_FOLDER + finalExportName + "_preview.png", new String[0]);
            Files.write(previewPath, images.get(0).image(), new OpenOption[0]);
            List<WrappedScene.ImageExport> galleryImages = images.subList(1, images.size());
            for (WrappedScene.ImageExport image : galleryImages) {
                Path path = Paths.get(IMAGE_FOLDER + finalExportName + count + ".png", new String[0]);
                Files.write(path, image.image(), new OpenOption[0]);
                imageFiles.add(path);
                ++count;
            }
            Template template = new Template(name, start, end);
            ApiResponse<UploadResponse> uploadResponse = BlockprintsApi.getInstance().upload().postUpload(name, description, template.toJson(), makePublic);
            if (!uploadResponse.wasSuccessful() || uploadResponse.response == null) {
                return ApiResponse.error(uploadResponse);
            }
            UploadResponse response = (UploadResponse)uploadResponse.response;
            String localStructureName = SceneExporter.sanitize(finalExportName + "_" + response.id);
            SchematicExport.SchematicExportResult result = SchematicExport.saveSchematic(Paths.get(STRUCTURE_FOLDER, new String[0]), localStructureName, false, this.structureTemplate, start, end);
            if (result == null) {
                return ApiResponse.error((Component)Component.m_237113_((String)"Could not save schematic locally"));
            }
            String preview = response.signedPreviewImage;
            String schematic = response.signedSchematic;
            boolean previewSuccess = GoogleCloudStorage.uploadFileToGCS(URI.create(preview).toURL(), previewPath, "image/png", response.imageFileSize);
            boolean structureSuccess = GoogleCloudStorage.uploadFileToGCS(URI.create(schematic).toURL(), result.file(), "application/octet-stream", response.schematicFileSize);
            if (!previewSuccess || !structureSuccess) {
                return ApiResponse.error((Component)Component.m_237113_((String)"Could not upload to GCS"));
            }
            for (int i = 0; i < response.signedImages.length && i < imageFiles.size(); ++i) {
                if (GoogleCloudStorage.uploadFileToGCS(URI.create(response.signedImages[i]).toURL(), (Path)imageFiles.get(i), "image/png", response.imageFileSize)) continue;
                return ApiResponse.error((Component)Component.m_237113_((String)"Could not upload to GCS"));
            }
            BlockprintsApi.getInstance().upload().postDoneUploading(response.id);
            return ApiResponse.success(response.id);
        }
        catch (ApiError | IOException | InterruptedException e) {
            e.printStackTrace();
            return ApiResponse.connectionError();
        }
    }

    public static String sanitize(String str) {
        return str.toLowerCase().replaceAll("[^a-z0-9]", "_").replaceAll(" ", "_");
    }
}

