/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.oauth;

import fabric.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import fabric.com.hollingsworth.schematic.api.blockprints.auth.BlockprintsToken;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_310;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;

public class Login {
    public static final String clientId = "874a3069-29ab-48a1-98d1-1d0c912e7b98";
    public static HttpServer server;
    public static String redirectUri;

    public static void startOAuthFlow(Consumer<BlockprintsToken> onSuccess) throws IOException {
        if (server != null) {
            server.stop();
        }
        server = null;
        for (int i = 0; i < 10; ++i) {
            try {
                server = Login.bootOnPort(3000 + i, onSuccess);
                redirectUri = "http://localhost:" + (3000 + i) + "/ms";
                break;
            }
            catch (Exception e) {
                server = null;
                continue;
            }
        }
        if (server == null) {
            throw new IOException("Failed to find open port");
        }
        server.start();
        class_156.method_668().method_670("https://login.microsoftonline.com/consumers/oauth2/v2.0/authorize?client_id=874a3069-29ab-48a1-98d1-1d0c912e7b98&response_type=code&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&response_mode=query&scope=" + URLEncoder.encode("XboxLive.signin offline_access", "UTF-8") + "&state=12345");
    }

    private static HttpServer bootOnPort(int port, Consumer<BlockprintsToken> onSuccess) throws IOException {
        server = ServerBootstrap.bootstrap().setListenerPort(port).registerHandler("/ms", (httpRequest, httpResponse, httpContext) -> {
            httpResponse.setEntity((HttpEntity)new StringEntity("<script> javascript:window.close()</script>", ContentType.TEXT_HTML));
            httpResponse.setStatusCode(200);
            try {
                List pairs = new URIBuilder(httpRequest.getRequestLine().getUri()).getQueryParams();
                String msCode = ((NameValuePair)pairs.get(0)).getValue();
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> BlockprintsApi.getInstance().auth().postMSCode(msCode), (Executor)class_310.method_1551()).thenAcceptAsync(response -> CompletableFuture.supplyAsync(() -> {
                    if (response.wasSuccessful()) {
                        onSuccess.accept((BlockprintsToken)response.response);
                    }
                    return response;
                }, (Executor)class_310.method_1551()), (Executor)class_310.method_1551())).get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            server.stop();
        }).create();
        server.start();
        return server;
    }

    public static void abortAuth() {
        if (server != null) {
            server.stop();
        }
    }

    static {
        redirectUri = "";
    }
}

