/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.hollingsworth.schematic.client.RaycastHelper;
import fabric.com.hollingsworth.schematic.client.renderer.DireBufferBuilder;
import fabric.com.hollingsworth.schematic.client.renderer.DireRenderMethods;
import fabric.com.hollingsworth.schematic.client.renderer.DireRenderTypes;
import fabric.com.hollingsworth.schematic.client.renderer.DireVertexConsumer;
import fabric.com.hollingsworth.schematic.client.renderer.FakeRenderingWorld;
import fabric.com.hollingsworth.schematic.client.renderer.RenderFluidBlock;
import fabric.com.hollingsworth.schematic.client.renderer.StatePos;
import fabric.com.hollingsworth.schematic.client.renderer.StructureRenderData;
import fabric.com.hollingsworth.schematic.common.util.Color;
import fabric.com.hollingsworth.schematic.common.util.DimPos;
import fabric.com.hollingsworth.schematic.platform.Services;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1087;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_824;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class StructureRenderer {
    public static ArrayList<StructureRenderData> structures = new ArrayList();
    private static int sortCounter = 0;
    private static final Map<class_1921, DireBufferBuilder> builders = class_1921.method_22720().stream().collect(Collectors.toMap(renderType -> renderType, type -> new DireBufferBuilder(type.method_22722())));
    private static final Map<class_1921, class_291> vertexBuffers = class_1921.method_22720().stream().collect(Collectors.toMap(renderType -> renderType, type -> new class_291(class_291.class_8555.field_44793)));

    public static DireBufferBuilder getBuffer(class_1921 renderType) {
        DireBufferBuilder buffer = builders.get(renderType);
        if (!buffer.method_22893()) {
            buffer.method_1328(renderType.method_23033(), renderType.method_23031());
        }
        return buffer;
    }

    public static void buildRender(StructureRenderData data, class_4587 poseStack, class_1657 player) {
        class_2338 renderPos;
        class_3965 lookingAt = RaycastHelper.getLookingAt(player, true);
        class_2338 class_23382 = renderPos = data.anchorPos == null ? lookingAt.method_17777() : data.anchorPos;
        if (renderPos == null) {
            return;
        }
        renderPos = renderPos.method_10084();
        DimPos boundTo = new DimPos((class_5321<class_1937>)player.field_6002.method_27983(), renderPos);
        if (boundTo != null && boundTo.levelKey().equals((Object)player.method_37908().method_27983())) {
            StructureRenderer.drawBoundBox(data, poseStack, boundTo.pos());
        }
        renderPos = renderPos.method_10084();
        if (StructureRenderer.shouldUpdateRender(player)) {
            StructureRenderer.generateRender(data, player.method_37908(), renderPos, 0.5f, data.statePosCache, vertexBuffers);
            data.updateRender = false;
        }
    }

    public static boolean shouldUpdateRender(class_1657 player) {
        return true;
    }

    public static void generateRender(StructureRenderData data, class_1937 level, class_2338 renderPos, float transparency, ArrayList<StatePos> statePosCache, Map<class_1921, class_291> vertexBuffers) {
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        data.fakeRenderingWorld = new FakeRenderingWorld(level, statePosCache, renderPos);
        class_4587 matrix = new class_4587();
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 modelBlockRenderer = dispatcher.method_3350();
        class_5819 random = class_5819.method_43047();
        for (StatePos pos2 : statePosCache.stream().filter(pos -> StructureRenderer.isModelRender(pos.state) || !pos.state.method_26227().method_15769()).toList()) {
            class_2680 renderState = data.fakeRenderingWorld.getBlockStateWithoutReal(pos2.pos);
            if (renderState.method_26215()) continue;
            class_1087 ibakedmodel = dispatcher.method_3349(renderState);
            matrix.method_22903();
            matrix.method_46416((float)pos2.pos.method_10263(), (float)pos2.pos.method_10264(), (float)pos2.pos.method_10260());
            for (class_1921 renderType : Services.PLATFORM.getRenderTypes(ibakedmodel, renderState, random)) {
                if (renderType.equals(class_1921.method_23581()) && renderState.method_26218((class_1922)level, pos2.pos.method_10081((class_2382)renderPos)).equals(class_259.method_1077())) {
                    renderType = class_1921.method_23583();
                }
                DireVertexConsumer direVertexConsumer = new DireVertexConsumer((class_4588)StructureRenderer.getBuffer(renderType), transparency);
                if (renderState.method_26227().method_15769()) {
                    try {
                        modelBlockRenderer.method_3374((class_1920)data.fakeRenderingWorld, ibakedmodel, renderState, pos2.pos.method_10081((class_2382)renderPos).method_10086(255), matrix, (class_4588)direVertexConsumer, false, random, renderState.method_26190(pos2.pos.method_10081((class_2382)renderPos)), class_4608.field_21444);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                RenderFluidBlock.renderFluidBlock(renderState, level, pos2.pos.method_10081((class_2382)renderPos).method_10086(255), matrix, direVertexConsumer, true);
            }
            matrix.method_22909();
        }
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        class_243 subtracted = projectedView.method_1023((double)renderPos.method_10263(), (double)renderPos.method_10264(), (double)renderPos.method_10260());
        Vector3f sortPos = new Vector3f((float)subtracted.field_1352, (float)subtracted.field_1351, (float)subtracted.field_1350);
        for (Map.Entry<class_1921, DireBufferBuilder> entry : builders.entrySet()) {
            class_1921 renderType;
            renderType = entry.getKey();
            DireBufferBuilder direBufferBuilder = StructureRenderer.getBuffer(renderType);
            direBufferBuilder.method_49904(class_8251.method_49909((Vector3f)sortPos));
            data.sortStates.put(renderType, direBufferBuilder.method_1334());
            class_291 vertexBuffer = vertexBuffers.get(entry.getKey());
            vertexBuffer.method_1353();
            vertexBuffer.method_1352(direBufferBuilder.method_1326());
            class_291.method_1354();
        }
    }

    public static void drawCopyBox(class_4587 matrix, class_2338 start, class_2338 end) {
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        matrix.method_22903();
        matrix.method_22904(-projectedView.method_10216(), -projectedView.method_10214(), -projectedView.method_10215());
        Color color = Color.GREEN;
        DireRenderMethods.renderCopy(matrix, start, end, color);
        matrix.method_22909();
    }

    public static void drawBoundBox(StructureRenderData data, class_4587 matrix, class_2338 blockPos) {
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        matrix.method_22903();
        matrix.method_22904(-projectedView.method_10216(), -projectedView.method_10214(), -projectedView.method_10215());
        Color color = Color.BLUE;
        class_3341 boundingBox = data.boundingBox;
        if (boundingBox != null) {
            class_2338 min = new class_2338(boundingBox.method_35415(), boundingBox.method_35416(), boundingBox.method_35417());
            class_2338 max = new class_2338(boundingBox.method_35418(), boundingBox.method_35419(), boundingBox.method_35420());
            min = min.method_10081((class_2382)blockPos);
            max = max.method_10081((class_2382)blockPos);
            DireRenderMethods.renderCopy(matrix, min, max, color);
        }
        matrix.method_22909();
    }

    public static boolean isModelRender(class_2680 state) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_1087 ibakedmodel = dispatcher.method_3349(state);
        for (class_2350 direction : class_2350.values()) {
            if (!ibakedmodel.method_4707(state, direction, class_5819.method_43047()).isEmpty()) {
                return true;
            }
            if (ibakedmodel.method_4707(state, null, class_5819.method_43047()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void drawRender(StructureRenderData data, class_4587 poseStack, Matrix4f projectionMatrix, class_1657 player) {
        if (vertexBuffers == null) {
            return;
        }
        class_2338 anchorPos = data.anchorPos;
        class_4597.class_4598 buffersource = class_310.method_1551().method_22940().method_23000();
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        class_3965 lookingAt = RaycastHelper.getLookingAt(player, true);
        class_2338 renderPos = anchorPos == null ? lookingAt.method_17777() : anchorPos;
        class_2680 lookingAtState = player.method_37908().method_8320(renderPos);
        if (lookingAtState.method_26215() && anchorPos == null) {
            return;
        }
        renderPos = renderPos.method_10084();
        if (sortCounter > 20) {
            StructureRenderer.sortAll(data, renderPos);
            sortCounter = 0;
        } else {
            ++sortCounter;
        }
        class_4587 matrix = poseStack;
        matrix.method_22903();
        matrix.method_22904(-projectedView.method_10216(), -projectedView.method_10214(), -projectedView.method_10215());
        matrix.method_46416((float)renderPos.method_10263(), (float)renderPos.method_10264(), (float)renderPos.method_10260());
        ArrayList<class_1921> drawSet = new ArrayList<class_1921>();
        drawSet.add(class_1921.method_23577());
        drawSet.add(class_1921.method_23581());
        drawSet.add(class_1921.method_23579());
        drawSet.add(class_1921.method_23583());
        drawSet.add(class_1921.method_29997());
        try {
            for (class_1921 renderType : drawSet) {
                class_1921 drawRenderType = renderType.equals(class_1921.method_23581()) ? DireRenderTypes.RenderBlock : class_1921.method_23583();
                class_291 vertexBuffer = vertexBuffers.get(renderType);
                if (vertexBuffer.method_34435() == null) continue;
                drawRenderType.method_23516();
                vertexBuffer.method_1353();
                vertexBuffer.method_34427(matrix.method_23760().method_23761(), new Matrix4f((Matrix4fc)projectionMatrix), RenderSystem.getShader());
                class_291.method_1354();
                drawRenderType.method_23518();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        matrix.method_22909();
        class_776 dispatcher = class_310.method_1551().method_1541();
        DireRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new DireRenderMethods.MultiplyAlphaRenderTypeBuffer((class_4597)buffersource, 0.5f);
        data.fakeRenderingWorld = new FakeRenderingWorld(player.method_37908(), data.statePosCache, renderPos);
        for (StatePos pos2 : data.statePosCache.stream().filter(pos -> !StructureRenderer.isModelRender(pos.state)).toList()) {
            if (pos2.state.method_26215()) continue;
            matrix.method_22903();
            matrix.method_22904(-projectedView.method_10216(), -projectedView.method_10214(), -projectedView.method_10215());
            matrix.method_46416((float)renderPos.method_10263(), (float)renderPos.method_10264(), (float)renderPos.method_10260());
            matrix.method_46416((float)pos2.pos.method_10263(), (float)pos2.pos.method_10264(), (float)pos2.pos.method_10260());
            class_824 blockEntityRenderer = class_310.method_1551().method_31975();
            class_2586 blockEntity = data.fakeRenderingWorld.method_8321(pos2.pos);
            if (blockEntity != null) {
                blockEntityRenderer.method_3555(blockEntity, 0.0f, matrix, (class_4597)multiplyAlphaRenderTypeBuffer);
            } else {
                DireRenderMethods.renderBETransparent(data.fakeRenderingWorld.method_8320(pos2.pos), matrix, (class_4597)buffersource, 0xF00000, 655360, 0.5f);
            }
            matrix.method_22909();
        }
    }

    public static void sortAll(StructureRenderData data, class_2338 lookingAt) {
        for (Map.Entry<class_1921, class_287.class_5594> entry : data.sortStates.entrySet()) {
            class_1921 renderType = entry.getKey();
            class_287.class_7433 renderedBuffer = StructureRenderer.sort(data, lookingAt, renderType);
            class_291 vertexBuffer = vertexBuffers.get(renderType);
            vertexBuffer.method_1353();
            vertexBuffer.method_1352(renderedBuffer);
            class_291.method_1354();
        }
    }

    public static class_287.class_7433 sort(StructureRenderData data, class_2338 lookingAt, class_1921 renderType) {
        class_243 projectedView = class_310.method_1551().field_1773.method_19418().method_19326();
        class_243 subtracted = projectedView.method_1023((double)lookingAt.method_10263(), (double)lookingAt.method_10264(), (double)lookingAt.method_10260());
        Vector3f sortPos = new Vector3f((float)subtracted.field_1352, (float)subtracted.field_1351, (float)subtracted.field_1350);
        DireBufferBuilder bufferBuilder = StructureRenderer.getBuffer(renderType);
        class_287.class_5594 sortState = data.sortStates.get(renderType);
        bufferBuilder.method_1324(sortState);
        bufferBuilder.method_49904(class_8251.method_49909((Vector3f)sortPos));
        data.sortStates.put(renderType, bufferBuilder.method_1334());
        return bufferBuilder.method_1326();
    }
}

