/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.renderer;

import fabric.com.hollingsworth.schematic.client.renderer.TagPos;
import fabric.com.hollingsworth.schematic.export.Template;
import fabric.com.hollingsworth.schematic.mixin.StructureTemplateAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_638;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public class StatePos {
    public class_2680 state;
    public class_2338 pos;

    public StatePos(class_2680 state, class_2338 pos) {
        this.state = state;
        this.pos = pos;
    }

    public StatePos(class_2487 compoundTag) {
        if (!compoundTag.method_10545("blockstate") || !compoundTag.method_10545("blockpos")) {
            this.state = null;
            this.pos = null;
        }
        this.state = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)compoundTag.method_10562("blockstate"));
        this.pos = class_2512.method_10691((class_2487)compoundTag.method_10562("blockpos"));
    }

    public StatePos(class_2487 compoundTag, ArrayList<class_2680> blockStates) {
        if (!compoundTag.method_10545("blockstateshort") || !compoundTag.method_10545("blockpos")) {
            this.state = null;
            this.pos = null;
        }
        this.state = blockStates.get(compoundTag.method_10568("blockstateshort"));
        this.pos = class_2338.method_10092((long)compoundTag.method_10537("blockpos"));
    }

    public class_2487 getTag() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566("blockstate", (class_2520)class_2512.method_10686((class_2680)this.state));
        compoundTag.method_10566("blockpos", (class_2520)class_2512.method_10692((class_2338)this.pos));
        return compoundTag;
    }

    public class_2487 getTag(ArrayList<class_2680> blockStates) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10575("blockstateshort", (short)blockStates.indexOf(this.state));
        compoundTag.method_10544("blockpos", this.pos.method_10063());
        return compoundTag;
    }

    public static ArrayList<StatePos> listFrom(class_3499 template) {
        StructureTemplateAccessor accessor = (StructureTemplateAccessor)template;
        ArrayList<StatePos> list = new ArrayList<StatePos>();
        List<class_3499.class_5162> palettes = accessor.getPalettes();
        if (palettes.isEmpty()) {
            return list;
        }
        class_3499.class_5162 palette = palettes.get(0);
        for (class_3499.class_3501 blockInfo : palette.method_27125()) {
            list.add(new StatePos(blockInfo.comp_1342(), blockInfo.comp_1341()));
        }
        return list;
    }

    public static ArrayList<class_2680> getBlockStateMap(ArrayList<StatePos> list) {
        ArrayList<class_2680> blockStateMap = new ArrayList<class_2680>();
        for (StatePos statePos : list) {
            if (blockStateMap.contains(statePos.state)) continue;
            blockStateMap.add(statePos.state);
        }
        return blockStateMap;
    }

    public static ArrayList<StatePos> rotate(ArrayList<StatePos> list, ArrayList<TagPos> tagListMutable, class_2470 rotation) {
        ArrayList<StatePos> rotatedList = new ArrayList<StatePos>();
        if (list == null || list.isEmpty()) {
            return rotatedList;
        }
        boolean tags = tagListMutable != null && !tagListMutable.isEmpty();
        Map<Object, Object> tagMap = new HashMap();
        if (tags) {
            tagMap = tagListMutable.stream().collect(Collectors.toMap(e -> e.pos, e -> e.tag));
        }
        for (StatePos statePos : list) {
            class_2338 oldPos = statePos.pos;
            class_2680 oldState = statePos.state;
            class_2680 newState = oldState.method_26186(rotation);
            class_2338 newPos = oldPos.method_10070(rotation);
            if (tags && tagMap.get(statePos.pos) != null) {
                class_2487 tempTag = (class_2487)tagMap.get(statePos.pos);
                tagMap.remove(statePos.pos);
                tagMap.put(newPos, tempTag);
            }
            rotatedList.add(new StatePos(newState, newPos));
        }
        if (tags) {
            tagListMutable.clear();
            for (Map.Entry entry : tagMap.entrySet()) {
                tagListMutable.add(new TagPos((class_2487)entry.getValue(), (class_2338)entry.getKey()));
            }
        }
        return rotatedList;
    }

    public static class_2499 getBlockStateNBT(ArrayList<class_2680> blockStateMap) {
        class_2499 listTag = new class_2499();
        for (class_2680 blockState : blockStateMap) {
            listTag.add((Object)class_2512.method_10686((class_2680)blockState));
        }
        return listTag;
    }

    public static ArrayList<class_2680> getBlockStateMapFromNBT(class_2499 listTag) {
        ArrayList<class_2680> blockStateMap = new ArrayList<class_2680>();
        for (int i = 0; i < listTag.size(); ++i) {
            class_2680 blockState = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)listTag.method_10602(i));
            blockStateMap.add(blockState);
        }
        return blockStateMap;
    }

    public static Map<Template.ItemStackKey, Integer> getItemList(ArrayList<StatePos> list) {
        Object2IntOpenHashMap itemList = new Object2IntOpenHashMap();
        if (list == null || list.isEmpty()) {
            return itemList;
        }
        for (StatePos statePos : list) {
            class_2338 blockPos = class_2338.field_10980;
            class_638 level = class_310.method_1551().field_1687;
            class_1799 cloneStack = statePos.state.method_26204().method_9574((class_1922)level, blockPos, statePos.state);
            Template.ItemStackKey itemStackKey = new Template.ItemStackKey(cloneStack, true);
            if (!itemList.containsKey(itemStackKey)) {
                itemList.put(itemStackKey, 1);
                continue;
            }
            itemList.put(itemStackKey, (Integer)itemList.get(itemStackKey) + 1);
        }
        return itemList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatePos) {
            return ((StatePos)obj).state.equals(this.state) && ((StatePos)obj).pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.state, this.pos);
    }
}

