/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import fabric.com.hollingsworth.schematic.api.blockprints.BlockprintsApi;
import fabric.com.hollingsworth.schematic.api.blockprints.favorites.Favorite;
import fabric.com.hollingsworth.schematic.api.blockprints.favorites.FavoritesResponse;
import fabric.com.hollingsworth.schematic.client.gui.BaseSchematicScreen;
import fabric.com.hollingsworth.schematic.client.gui.FavoritesRow;
import fabric.com.hollingsworth.schematic.client.gui.GuiImageButton;
import fabric.com.hollingsworth.schematic.client.gui.GuiUtils;
import fabric.com.hollingsworth.schematic.client.gui.HomeScreen;
import fabric.com.hollingsworth.schematic.client.gui.LoadingScreen;
import fabric.com.hollingsworth.schematic.client.gui.ManageVisualScreen;
import fabric.com.hollingsworth.schematic.client.gui.ToggleImageButton;
import fabric.com.hollingsworth.schematic.client.gui.VerticalSlider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class ViewFavoritesScreen
extends BaseSchematicScreen {
    protected FavoritesResponse res = null;
    List<Favorite> favorites = new ArrayList<Favorite>();
    List<FavoritesRow> rows = new ArrayList<FavoritesRow>();
    public boolean showFavorites = true;
    public boolean showBuilds = true;
    public boolean showRecent = true;
    int scroll = 0;

    public ViewFavoritesScreen(FavoritesResponse favoritesResponse) {
        this(favoritesResponse, true, true, true);
    }

    public static LoadingScreen<FavoritesResponse> getTransition() {
        return new LoadingScreen<FavoritesResponse>(() -> BlockprintsApi.getInstance().favorites().getFavorites(), favorites -> class_310.method_1551().method_1507((class_437)new ViewFavoritesScreen((FavoritesResponse)favorites)));
    }

    public static LoadingScreen<FavoritesResponse> getTransition(ViewFavoritesScreen previousScreen) {
        return new LoadingScreen<FavoritesResponse>(() -> BlockprintsApi.getInstance().favorites().getFavorites(), favorites -> class_310.method_1551().method_1507((class_437)new ViewFavoritesScreen((FavoritesResponse)favorites, previousScreen.showFavorites, previousScreen.showBuilds, previousScreen.showRecent)), previousScreen);
    }

    public static LoadingScreen<FavoritesResponse> getTransition(boolean showFavorites, boolean showBuilds, boolean showRecent) {
        return new LoadingScreen<FavoritesResponse>(() -> BlockprintsApi.getInstance().favorites().getFavorites(showFavorites, showBuilds, showRecent), favorites -> class_310.method_1551().method_1507((class_437)new ViewFavoritesScreen((FavoritesResponse)favorites, showFavorites, showBuilds, showRecent)), null, 30);
    }

    public ViewFavoritesScreen(FavoritesResponse favoritesResponse, boolean showFavorites, boolean showBuilds, boolean showRecent) {
        this.favorites = favoritesResponse.favorites;
        this.res = favoritesResponse;
        this.showFavorites = showFavorites;
        this.showBuilds = showBuilds;
        this.showRecent = showRecent;
        this.favorites.sort((o1, o2) -> {
            if (o1.isBuild() && !o2.isBuild()) {
                return -1;
            }
            if (!o1.isBuild() && o2.isBuild()) {
                return 1;
            }
            if (o1.isFavorite() && !o2.isFavorite()) {
                return -1;
            }
            if (!o1.isFavorite() && o2.isFavorite()) {
                return 1;
            }
            if (o1.isRecent() && !o2.isRecent()) {
                return -1;
            }
            if (!o1.isRecent() && o2.isRecent()) {
                return 1;
            }
            return o1.name().compareTo(o2.name());
        });
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.updateList();
        int scrollSize = Math.max(0, this.favorites.size() - 10);
        this.method_37063(new VerticalSlider(this.bookLeft + 265, this.bookTop + 46, scrollSize, 1.0, 1, count -> {
            this.scroll = count;
            this.updateList();
        }));
        class_2960 unchecked = new class_2960("blockprints", "textures/gui/container_filter_unchecked.png");
        class_2960 checked = new class_2960("blockprints", "textures/gui/container_filter_checked.png");
        this.method_37063(new ToggleImageButton(this.bookLeft + 206, this.bookTop + 29, 7, 7, unchecked, checked, b -> {
            this.showBuilds = !this.showBuilds;
            this.queryFavorites();
        }, () -> this.showBuilds).withTooltip((class_2561)class_2561.method_43471((String)"blockprints.filter_own_builds")));
        this.method_37063(new ToggleImageButton(this.bookLeft + 224, this.bookTop + 29, 7, 7, unchecked, checked, b -> {
            this.showFavorites = !this.showFavorites;
            this.queryFavorites();
        }, () -> this.showFavorites).withTooltip((class_2561)class_2561.method_43471((String)"blockprints.filter_favorites")));
        this.method_37063(new ToggleImageButton(this.bookLeft + 244, this.bookTop + 29, 7, 7, unchecked, checked, b -> {
            this.showRecent = !this.showRecent;
            this.queryFavorites();
        }, () -> this.showRecent).withTooltip((class_2561)class_2561.method_43471((String)"blockprints.filter_recent_builds")));
        this.method_37063(new GuiImageButton(this.bookLeft + 9, this.bookTop + 9, 15, 15, new class_2960("blockprints", "textures/gui/button_back.png"), b -> class_310.method_1551().method_1507((class_437)new HomeScreen())));
        this.method_37063(new GuiImageButton(this.bookLeft + 25, this.bookTop + 9, 79, 15, new class_2960("blockprints", "textures/gui/button_5.png"), b -> class_310.method_1551().method_1507((class_437)new ManageVisualScreen()))).withTooltip((class_2561)class_2561.method_43471((String)"blockprints.visualize_list_tooltip"));
    }

    public void updateList() {
        for (FavoritesRow row : this.rows) {
            this.method_37066((class_364)row);
        }
        this.rows = new ArrayList<FavoritesRow>();
        List<Favorite> sliced = this.favorites.subList(this.scroll, Math.min(this.scroll + 10, this.favorites.size()));
        for (int i = 0; i < Math.min(sliced.size(), 10); ++i) {
            Favorite entry = sliced.get(i);
            FavoritesRow row = new FavoritesRow(this.bookLeft + 26, this.bookTop + 44 + i * 14, entry, this);
            this.rows.add(row);
            this.method_37063(row);
        }
    }

    public void queryFavorites() {
        class_310.method_1551().method_1507(ViewFavoritesScreen.getTransition(this.showFavorites, this.showBuilds, this.showRecent));
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_visualize.png"), this.bookLeft + 28, this.bookTop + 13, 0.0f, 0.0f, 9, 7, 9, 7);
        GuiUtils.drawCenteredOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.visual_list").method_30937(), this.bookLeft + 70, this.bookTop + 13);
    }

    @Override
    public void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/container_list_builds.png"), 25, 25, 0.0f, 0.0f, 239, 159, 239, 159);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_my_builds.png"), 214, 29, 0.0f, 0.0f, 5, 7, 5, 7);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_favorite_builds.png"), 232, 29, 0.0f, 0.0f, 7, 7, 7, 7);
        graphics.method_25290(new class_2960("blockprints", "textures/gui/icon_recent_builds.png"), 252, 29, 0.0f, 0.0f, 7, 7, 7, 7);
        GuiUtils.drawOutlinedText(this.field_22793, graphics, class_2561.method_43471((String)"blockprints.builds").method_30937(), 30, 29);
    }
}

