/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.hollingsworth.schematic.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.hollingsworth.schematic.client.gui.GuiUtils;
import fabric.com.hollingsworth.schematic.common.util.ITooltipProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public abstract class ModScreen
extends class_437 {
    public int maxScale;
    public float scaleFactor;
    public int FULL_WIDTH;
    public int FULL_HEIGHT;
    public int bookLeft;
    public int bookTop;
    public int bookRight;
    public int bookBottom;

    public ModScreen(int width, int height) {
        super((class_2561)class_2561.method_43473());
        this.FULL_HEIGHT = height;
        this.FULL_WIDTH = width;
    }

    public void method_25426() {
        super.method_25426();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0f;
        this.bookLeft = this.field_22789 / 2 - this.FULL_WIDTH / 2;
        this.bookTop = this.field_22790 / 2 - this.FULL_HEIGHT / 2;
        this.bookRight = this.field_22789 / 2 + this.FULL_WIDTH / 2;
        this.bookBottom = this.field_22790 / 2 + this.FULL_HEIGHT / 2;
    }

    public void method_25394(class_332 matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        class_4587 poseStack = matrixStack.method_51448();
        poseStack.method_22903();
        if (this.scaleFactor != 1.0f) {
            poseStack.method_22905(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(matrixStack, mouseX, mouseY, partialTicks);
        poseStack.method_22909();
    }

    public void drawTooltip(class_332 stack, int mouseX, int mouseY) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        this.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (!tooltip.isEmpty()) {
            stack.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
    }

    public void collectTooltips(class_332 stack, int mouseX, int mouseY, List<class_2561> tooltip) {
        for (class_4068 renderable : this.field_33816) {
            if (!(renderable instanceof class_339)) continue;
            class_339 widget = (class_339)renderable;
            if (!(renderable instanceof ITooltipProvider)) continue;
            ITooltipProvider tooltipProvider = (ITooltipProvider)renderable;
            if (!GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget)) continue;
            tooltipProvider.getTooltip(tooltip);
            break;
        }
    }

    @Nullable
    public class_4068 getHoveredRenderable(int mouseX, int mouseY) {
        for (class_4068 renderable : this.field_33816) {
            class_339 widget;
            if (!(renderable instanceof class_339) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget = (class_339)renderable)) continue;
            return renderable;
        }
        return null;
    }

    public void drawBackgroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25290(this.getBgTexture(), 0, 0, 0.0f, 0.0f, this.FULL_WIDTH, this.FULL_HEIGHT, this.FULL_WIDTH, this.FULL_HEIGHT);
    }

    public void drawForegroundElements(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScreenAfterScale(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)this.bookLeft, (float)this.bookTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(graphics, mouseX, mouseY, partialTicks);
        poseStack.method_22909();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    public boolean method_25421() {
        return false;
    }

    private int getMaxAllowedScale() {
        return this.field_22787.method_22683().method_4476(0, this.field_22787.method_1573());
    }

    public abstract class_2960 getBgTexture();

    public static void blitRect(class_4587 matrixStack, float x0, float y0, float xt, float yt, float width, float height, int tWidth, int tHeight, class_2960 texture, int alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        float tx0 = xt / (float)tWidth;
        float ty0 = yt / (float)tHeight;
        float tx1 = tx0 + width / (float)tWidth;
        float ty1 = ty0 + height / (float)tHeight;
        float x1 = x0 + width;
        float y1 = y0 + height;
        class_289 tess = class_289.method_1348();
        class_287 builder = tess.method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        builder.method_22918(matrix, x0, y1, 0.0f).method_22913(tx0, ty1).method_1344();
        builder.method_22918(matrix, x1, y1, 0.0f).method_22913(tx1, ty1).method_1344();
        builder.method_22918(matrix, x1, y0, 0.0f).method_22913(tx1, ty0).method_1344();
        builder.method_22918(matrix, x0, y0, 0.0f).method_22913(tx0, ty0).method_1344();
        tess.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

